/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.visiteamap;

import fr.amapj.common.CollectionUtils;
import fr.amapj.common.collections.G1D;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.ModeleContratDate;
import fr.amapj.model.models.contrat.modele.ModeleContratProduit;
import fr.amapj.model.models.contrat.reel.ContratCell;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.mescontrats.small.SmallContratDTO;
import fr.amapj.service.services.mescontrats.small.SmallContratsService;
import fr.amapj.service.services.meslivraisons.MesLivraisonsService;
import fr.amapj.service.services.meslivraisons.QteProdDTO;
import fr.amapj.service.services.visiteamap.VisiteAmapDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.TemporalType;

public class VisiteAmapService {
    @DbRead
    public VisiteAmapDTO getAll(Date dateDebut, Date dateFin, Long idUtilisateur) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArrayList<VisiteAmapDTO.LigneContrat> ligneContrats = new ArrayList<VisiteAmapDTO.LigneContrat>();
            em.createQuery("select c from ModeleContratDate c WHERE c.dateLiv>=:deb AND c.dateLiv<=:fin AND c.modeleContrat.etat<>:etat  AND c NOT IN (select mce.date from ModeleContratExclude mce where mce.produit is null)");
            em.setParameter("deb", dateDebut, TemporalType.DATE);
            em.setParameter("fin", dateFin, TemporalType.DATE);
            em.setParameter("etat", (Object)EtatModeleContrat.CREATION);
            List<ModeleContratDate> mcds = em.result().list(ModeleContratDate.class);
            for (ModeleContratDate modeleContratDate : mcds) {
                em.createQuery("select c from ModeleContratProduit c WHERE c.modeleContrat=:mc AND c NOT IN (select mce.produit from ModeleContratExclude mce where mce.date = :mcd) ");
                em.setParameter("mc", modeleContratDate.modeleContrat);
                em.setParameter("mcd", modeleContratDate);
                List<ModeleContratProduit> mcps = em.result().list(ModeleContratProduit.class);
                for (ModeleContratProduit modeleContratProduit : mcps) {
                    VisiteAmapDTO.LigneContrat line = this.createLineDto(modeleContratProduit, modeleContratDate);
                    ligneContrats.add(line);
                }
            }
            VisiteAmapDTO res = new VisiteAmapDTO();
            res.jours = this.getAllJours(ligneContrats);
            if (idUtilisateur != null) {
                List<SmallContratDTO> contrats = new SmallContratsService().getMesContrats(idUtilisateur);
                Utilisateur utilisateur = em.find(Utilisateur.class, idUtilisateur);
                List<ContratCell> mesLivraisons = new MesLivraisonsService().getAllQte(em, dateDebut, dateFin, utilisateur);
                CollectionUtils.forEach(res.jours, e -> e.producteurs, e -> e.contrats, e -> this.completeContrat(em, (VisiteAmapDTO.Contrat)e, contrats, mesLivraisons));
            }
            VisiteAmapDTO visiteAmapDTO = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return visiteAmapDTO;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<VisiteAmapDTO.Jour> getAllJours(List<VisiteAmapDTO.LigneContrat> ligneContrats) {
        return G1D.groupBy(ligneContrats, e -> e.dateLiv).sortLigNatural(true).compute().getAs(e -> this.createJour((G1D.Cell1<Date, VisiteAmapDTO.LigneContrat>)e));
    }

    private VisiteAmapDTO.Jour createJour(G1D.Cell1<Date, VisiteAmapDTO.LigneContrat> cell1) {
        VisiteAmapDTO.Jour jour = new VisiteAmapDTO.Jour();
        jour.dateLiv = (Date)cell1.lig;
        jour.producteurs = this.getAllProducteurs(cell1.values);
        return jour;
    }

    private List<VisiteAmapDTO.Producteur> getAllProducteurs(List<VisiteAmapDTO.LigneContrat> ligneContrats) {
        return G1D.groupBy(ligneContrats, e -> e.producteurNom).sortLigNatural(true).compute().getAs(e -> this.createProducteur((G1D.Cell1<String, VisiteAmapDTO.LigneContrat>)e));
    }

    private VisiteAmapDTO.Producteur createProducteur(G1D.Cell1<String, VisiteAmapDTO.LigneContrat> cell1) {
        VisiteAmapDTO.Producteur producteur = new VisiteAmapDTO.Producteur();
        producteur.producteurNom = (String)cell1.lig;
        producteur.contrats = this.getAllContrats(cell1.values);
        return producteur;
    }

    private List<VisiteAmapDTO.Contrat> getAllContrats(List<VisiteAmapDTO.LigneContrat> ligneContrats) {
        return G1D.groupBy(ligneContrats, e -> e.modeleContratNom).sortLigNatural(true).compute().getAs(e -> this.createContrat((G1D.Cell1<String, VisiteAmapDTO.LigneContrat>)e));
    }

    private VisiteAmapDTO.Contrat createContrat(G1D.Cell1<String, VisiteAmapDTO.LigneContrat> cell1) {
        VisiteAmapDTO.Contrat contrat = new VisiteAmapDTO.Contrat();
        contrat.contratNom = (String)cell1.lig;
        contrat.modeleContratId = ((VisiteAmapDTO.LigneContrat)cell1.ref).modeleContratId;
        contrat.modeleContratDateId = ((VisiteAmapDTO.LigneContrat)cell1.ref).modeleContratDateId;
        contrat.ligneContrats = cell1.values;
        return contrat;
    }

    private VisiteAmapDTO.LigneContrat createLineDto(ModeleContratProduit mcp, ModeleContratDate mcd) {
        VisiteAmapDTO.LigneContrat line = new VisiteAmapDTO.LigneContrat();
        line.dateLiv = mcd.dateLiv;
        line.producteurNom = mcd.modeleContrat.producteur.nom;
        line.producteurId = mcd.modeleContrat.producteur.id;
        line.modeleContratNom = mcd.modeleContrat.nom;
        line.modeleContratId = mcd.modeleContrat.id;
        line.modeleContratDateId = mcd.id;
        line.produitPrix = mcp.prix;
        line.produitNom = mcp.produit.nom;
        line.produitConditionnement = mcp.produit.conditionnement;
        line.produitId = mcp.produit.id;
        line.produitIndx = mcp.indx;
        return line;
    }

    private void completeContrat(RdbLink em, VisiteAmapDTO.Contrat contrat, List<SmallContratDTO> contrats, List<ContratCell> mesLivraisons) {
        contrat.contratDTO = contrats.stream().filter(e -> e.modeleContratId.equals(contrat.modeleContratId)).findFirst().orElse(null);
        if (contrat.contratDTO != null && contrat.contratDTO.contratId != null) {
            contrat.qteProdDTOs = mesLivraisons.stream().filter(e -> e.modeleContratDate.id.equals(contrat.modeleContratDateId)).map(e -> this.createQteProdDTO((ContratCell)e)).collect(Collectors.toList());
        }
    }

    private QteProdDTO createQteProdDTO(ContratCell cell) {
        QteProdDTO qteProdDTO = new QteProdDTO();
        qteProdDTO.conditionnementProduit = cell.modeleContratProduit.produit.conditionnement;
        qteProdDTO.nomProduit = cell.modeleContratProduit.produit.nom;
        qteProdDTO.idProduit = cell.modeleContratProduit.produit.getId();
        qteProdDTO.qte = cell.qte;
        return qteProdDTO;
    }

    @DbRead
    public Date provideNextDate(Date ref, boolean next) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (next) {
                em.createQuery("select min(c.dateLiv) from ModeleContratDate c WHERE c.dateLiv>=:ref AND c.modeleContrat.etat<>:etat AND c NOT IN (select mce.date from ModeleContratExclude mce where mce.produit is null)");
            } else {
                em.createQuery("select max(c.dateLiv) from ModeleContratDate c WHERE c.dateLiv<:ref AND c.modeleContrat.etat<>:etat AND c NOT IN (select mce.date from ModeleContratExclude mce where mce.produit is null)");
            }
            em.setParameter("ref", ref);
            em.setParameter("etat", (Object)EtatModeleContrat.CREATION);
            Date date = em.result().oneOrZero(Date.class);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return date;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

