/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.collectioneditor;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.view.engine.collectioneditor.Row;
import java.util.ArrayList;
import java.util.List;

public class RowList {
    private List<Row> rows = new ArrayList<Row>();
    private int nbLignes = 0;

    public void add(Row row, Object idBeanInfo) {
        Integer itemId = new Integer(this.nbLignes);
        row.setItemId(itemId);
        row.setIdBeanInfo(idBeanInfo);
        this.rows.add(row);
        ++this.nbLignes;
    }

    public Object remove(Object itemId) {
        int s = this.rows.size();
        int i = 0;
        while (i < s) {
            Row line = this.rows.get(i);
            if (line.getItemId() == itemId) {
                this.rows.remove(line);
                if (s == 1) {
                    return null;
                }
                if (i == s - 1) {
                    return this.rows.get(s - 2).getItemId();
                }
                return this.rows.get(i).getItemId();
            }
            ++i;
        }
        throw new AmapjRuntimeException();
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public int getIndex(Object itemId) {
        int i = 0;
        for (Row line : this.rows) {
            if (line.getItemId() == itemId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean canDown(int index) {
        return index != this.rows.size() - 1;
    }

    public Object downRow(int index) {
        Row r1 = this.rows.get(index);
        Row r2 = this.rows.get(index + 1);
        int s = r1.getNbFields();
        int col = 0;
        while (col < s) {
            Object val1 = r1.getFieldValue(col);
            Object val2 = r2.getFieldValue(col);
            r1.setFieldValue(col, val2);
            r2.setFieldValue(col, val1);
            ++col;
        }
        this.switchIdBeanInfo(r1, r2);
        return r2.getItemId();
    }

    public boolean canUp(int index) {
        return index != 0;
    }

    public Object upRow(int index) {
        Row r1 = this.rows.get(index);
        Row r2 = this.rows.get(index - 1);
        int s = r1.getNbFields();
        int col = 0;
        while (col < s) {
            Object val1 = r1.getFieldValue(col);
            Object val2 = r2.getFieldValue(col);
            r1.setFieldValue(col, val2);
            r2.setFieldValue(col, val1);
            ++col;
        }
        this.switchIdBeanInfo(r1, r2);
        return r2.getItemId();
    }

    private void switchIdBeanInfo(Row r1, Row r2) {
        Object idBeanInfo1 = r1.getIdBeanInfo();
        Object idBeanInfo2 = r2.getIdBeanInfo();
        r1.setIdBeanInfo(idBeanInfo2);
        r2.setIdBeanInfo(idBeanInfo1);
    }
}

