/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.enumselector;

import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.metadata.MetaDataEnum;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.io.Serializable;
import java.util.EnumSet;

public class EnumSearcher {
    public static <T extends Enum<T>> HorizontalLayout createEnumSearcher(FieldGroup binder, String title, String propertyId, String overrideHelpText, T ... enumsToExcludes) {
        Class enumeration = binder.getItemDataSource().getItemProperty((Object)propertyId).getType();
        if (!enumeration.isEnum()) {
            throw new AmapjRuntimeException("Le champ " + title + " n'est pas de type enum");
        }
        MetaDataEnum.HelpInfo metaData = MetaDataEnum.getHelpInfo(enumeration);
        String helpText = EnumSearcher.computeHelpText(overrideHelpText, metaData, enumsToExcludes);
        ComboBox comboBox = new ComboBox();
        comboBox.setWidth("300px");
        EnumSet<Enum> enums = EnumSet.allOf(enumeration);
        for (Enum en : enums) {
            if (!EnumSearcher.isAllowed((Enum)en, enumsToExcludes)) continue;
            String caption = EnumSearcher.getCaption(metaData, en);
            comboBox.addItem((Object)en);
            comboBox.setItemCaption((Object)en, caption);
        }
        binder.bind((Field)comboBox, (Object)propertyId);
        comboBox.setImmediate(true);
        HorizontalLayout hl = new HorizontalLayout();
        hl.setCaption(title);
        hl.addComponent((Component)comboBox);
        if (helpText != null) {
            Button aide = new Button();
            aide.setIcon((Resource)FontAwesome.QUESTION_CIRCLE);
            aide.addStyleName("borderless-colored");
            aide.addStyleName("question-mark");
            aide.addClickListener((Button.ClickListener & Serializable)e -> new MessagePopup("Aide", ContentMode.HTML, CorePopup.ColorStyle.GREEN, helpText).open());
            hl.addComponent((Component)aide);
        }
        return hl;
    }

    private static String computeHelpText(String overrideHelpText, MetaDataEnum.HelpInfo metaData, Enum[] enumsToExcludes) {
        if (overrideHelpText != null) {
            return overrideHelpText;
        }
        if (metaData != null) {
            return metaData.getFullText(enumsToExcludes);
        }
        return null;
    }

    private static <T extends Enum<T>> String getCaption(MetaDataEnum.HelpInfo metaData, T en) {
        if (metaData == null) {
            return en.toString();
        }
        return metaData.getLib(en);
    }

    private static <T extends Enum<T>> boolean isAllowed(T en, T[] enumsToExcludes) {
        if (enumsToExcludes == null) {
            return true;
        }
        int i = 0;
        while (i < enumsToExcludes.length) {
            T enum1 = enumsToExcludes[i];
            if (((Enum)enum1).equals(en)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T extends Enum<T>> ComboBox createEnumSearcher(String title, T enumeration) {
        ComboBox comboBox = new ComboBox(title);
        EnumSet<Enum> enums = EnumSet.allOf(enumeration.getDeclaringClass());
        for (Enum en : enums) {
            String caption = en.toString();
            comboBox.addItem((Object)en);
            comboBox.setItemCaption((Object)en, caption);
        }
        comboBox.setValue(enumeration);
        return comboBox;
    }

    public static <T extends Enum<T>> ComboBox createEnumSearcher(String title, Class<? extends Enum> enumClazz) {
        ComboBox comboBox = new ComboBox(title);
        EnumSet<? extends Enum> enums = EnumSet.allOf(enumClazz);
        for (Enum enum_ : enums) {
            String caption = enum_.toString();
            comboBox.addItem((Object)enum_);
            comboBox.setItemCaption((Object)enum_, caption);
        }
        return comboBox;
    }
}

