/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.excelgenerator;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.CoreGeneratorService;
import fr.amapj.service.engine.generator.FileInfoDTO;
import fr.amapj.view.engine.excelgenerator.CoreResource;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TelechargerPopup
extends CorePopup {
    private List<Item> items = new ArrayList<Item>();

    public TelechargerPopup(String popupTitle) {
        this.popupTitle = popupTitle;
    }

    public TelechargerPopup(String popupTitle, int width) {
        this.popupTitle = popupTitle;
        this.setWidth(width);
    }

    public void addGenerator(CoreGenerator generator) {
        if (generator == null) {
            return;
        }
        Item item = new Item();
        item.generator = generator;
        this.items.add(item);
    }

    public void addSeparator() {
        this.addLabel("----");
    }

    public void addLabel(String label) {
        Item item = new Item();
        item.label = label;
        this.items.add(item);
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        contentLayout.addStyleName("popup-telecharger");
        Label l = new Label("Veuillez cliquer sur le lien du fichier que vous souhaitez t\u00e9l\u00e9charger");
        l.addStyleName("titre");
        contentLayout.addComponent((Component)l);
        ArrayList<CoreGenerator> gs = new ArrayList<CoreGenerator>();
        for (Item item : this.items) {
            if (item.generator == null) continue;
            gs.add(item.generator);
        }
        List<FileInfoDTO> fileInfoDTOs = new CoreGeneratorService().getFileInfo(gs);
        int i = 0;
        for (Item item : this.items) {
            if (item.generator != null) {
                FileInfoDTO fileInfoDTO = fileInfoDTOs.get(i);
                this.addLink(contentLayout, fileInfoDTO);
                ++i;
                continue;
            }
            Label lab = new Label(item.label, ContentMode.HTML);
            lab.addStyleName("separateur");
            contentLayout.addComponent((Component)lab);
        }
    }

    private void addLink(VerticalLayout contentLayout, FileInfoDTO fileInfoDTO) {
        String titre = fileInfoDTO.nameToDisplay;
        String fileName = fileInfoDTO.fileName;
        String extension = fileInfoDTO.extension;
        StreamResource streamResource = new StreamResource((StreamResource.StreamSource)new CoreResource(fileInfoDTO.generator), String.valueOf(fileName) + "." + extension);
        streamResource.setCacheTime(1000L);
        Link extractFile = new Link(titre, (Resource)streamResource);
        extractFile.setIcon((Resource)FontAwesome.DOWNLOAD);
        extractFile.setTargetName("_blank");
        contentLayout.addComponent((Component)extractFile);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addButton("Quitter", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
    }

    protected void handleAnnuler() {
        this.close();
    }

    private static class Item {
        public CoreGenerator generator;
        public String label;

        private Item() {
        }
    }
}

