/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.grid.utils.HelpPopupSupplier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GridHeaderLine {
    public int height = -1;
    public GridHeaderLineStyle style = GridHeaderLineStyle.STANDARD;
    public List<GridHeaderLineCell> cells = new ArrayList<GridHeaderLineCell>();

    public void addCell(String content) {
        this.cells.add(new GridHeaderLineCell(content));
    }

    public void addCell(String content, HelpSupplier helpSupplier) {
        this.cells.add(new GridHeaderLineCell(content, helpSupplier));
    }

    public boolean hasHelp() {
        for (GridHeaderLineCell cell : this.cells) {
            if (!cell.hasHelp()) continue;
            return true;
        }
        return false;
    }

    public void constructHeaderLine(VerticalLayout mainLayout, int leftPartLineLargeur, int largeurCol) {
        boolean hasHelp = this.hasHelp();
        HorizontalLayout header1 = new HorizontalLayout();
        if (this.height != -1) {
            int h = (hasHelp ? 28 : 0) + this.height;
            header1.setHeight(String.valueOf(h) + "px");
        }
        int index = 0;
        for (GridHeaderLineCell cell : this.cells) {
            VerticalLayout vl = new VerticalLayout();
            vl.setMargin(false);
            vl.setSpacing(false);
            vl.addStyleName("gridheaderline");
            vl.setHeight("100%");
            if (index == 0) {
                vl.setWidth(String.valueOf(leftPartLineLargeur + 5) + "px");
            } else {
                vl.setWidth(String.valueOf(largeurCol + 2) + "px");
            }
            Label dateLabel = new Label(cell.content);
            dateLabel.setSizeFull();
            dateLabel.addStyleName("gridheaderline");
            if (this.style == GridHeaderLineStyle.PRIX) {
                dateLabel.addStyleName("gridheaderline-prix");
            }
            vl.addComponent((Component)dateLabel);
            vl.setExpandRatio((Component)dateLabel, 1.0f);
            if (cell.hasHelp()) {
                Button btn = new Button((Resource)FontAwesome.QUESTION_CIRCLE);
                btn.addStyleName("gridheaderline");
                btn.addStyleName("borderless-colored");
                btn.addStyleName("question-mark");
                btn.addClickListener((Button.ClickListener & Serializable)e -> HelpPopupSupplier.displayHelpPopup(gridHeaderLineCell.helpSupplier));
                vl.addComponent((Component)btn);
                vl.setComponentAlignment((Component)btn, Alignment.BOTTOM_CENTER);
            }
            header1.addComponent((Component)vl);
            ++index;
        }
        mainLayout.addComponent((Component)header1);
    }

    public static class GridHeaderLineCell {
        public String content;
        public HelpSupplier helpSupplier;

        public GridHeaderLineCell(String content) {
            this.content = content;
        }

        public GridHeaderLineCell(String content, HelpSupplier helpSupplier) {
            this.content = content;
            this.helpSupplier = helpSupplier;
        }

        public boolean hasHelp() {
            if (this.helpSupplier == null) {
                return false;
            }
            return this.helpSupplier.hasHelp();
        }
    }

    public static enum GridHeaderLineStyle {
        STANDARD,
        PRIX;

    }

    public static interface HelpSupplier {
        public boolean hasHelp();

        public String helpText1();

        public String helpText2();
    }
}

