/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.booleangrid;

import com.vaadin.data.Item;
import com.vaadin.server.WebBrowser;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.grid.ErreurSaisieException;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.booleangrid.BooleanGridParam;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.io.Serializable;
import java.util.ArrayList;
import javax.validation.ConstraintViolationException;

public abstract class PopupBooleanGrid
extends CorePopup {
    protected Table table;
    protected Button saveButton;
    protected String saveButtonTitle = "Sauvegarder";
    protected Button cancelButton;
    protected String cancelButtonTitle = "Annuler";
    protected BooleanGridParam param = new BooleanGridParam();
    private boolean errorInInitialCondition = false;

    public PopupBooleanGrid() {
        this.setHeight("90%");
    }

    public abstract void loadParam();

    public abstract void performSauvegarder() throws OnSaveException;

    @Override
    protected void createContent(VerticalLayout mainLayout) {
        this.setType(CorePopup.PopupType.CENTERFIT);
        String str = this.checkInitialCondition();
        if (str != null) {
            this.errorInInitialCondition = true;
            this.popupTitle = "Impossible";
            this.displayErrorOnInitialCondition(str, mainLayout);
            return;
        }
        this.loadParam();
        if (this.param.messageSpecifique != null) {
            mainLayout.addComponent((Component)new Label(this.param.messageSpecifique, ContentMode.HTML));
        }
        for (GridHeaderLine line : this.param.headerLines) {
            line.constructHeaderLine(mainLayout, this.param.largeurCol, this.param.largeurCol);
        }
        this.table = new Table();
        this.table.addStyleName("no-vertical-lines");
        this.table.addStyleName("no-horizontal-lines");
        this.table.addStyleName("no-stripes");
        this.table.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.table.addContainerProperty((Object)new Integer(-1), Label.class, null);
        this.table.setColumnWidth((Object)new Integer(-1), this.param.largeurCol);
        if (this.param.leftPartLine2 != null) {
            this.table.addContainerProperty((Object)new Integer(-2), Label.class, null);
            this.table.setColumnWidth((Object)new Integer(-2), this.param.largeurCol);
        }
        int i = 0;
        while (i < this.param.nbCol) {
            this.table.addContainerProperty((Object)new Integer(i), CheckBox.class, null);
            this.table.setColumnWidth((Object)new Integer(i), this.param.largeurCol);
            ++i;
        }
        i = 0;
        while (i < this.param.nbLig) {
            this.addRow(i);
            ++i;
        }
        this.table.setEditable(true);
        this.table.setSelectable(true);
        this.table.setSortEnabled(false);
        this.table.setPageLength(this.getPageLength());
        mainLayout.addComponent((Component)this.table);
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        if (this.errorInInitialCondition) {
            this.addButton("OK", (Button.ClickListener & Serializable)e -> this.close());
            return;
        }
        this.cancelButton = this.addButton(this.cancelButtonTitle, (Button.ClickListener & Serializable)e -> this.handleAnnuler());
        this.saveButton = this.addDefaultButton(this.saveButtonTitle, (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
    }

    private int getPageLength() {
        WebBrowser webBrowser = UI.getCurrent().getPage().getWebBrowser();
        int pageLength = 15;
        if (webBrowser.isIE() && webBrowser.getBrowserMajorVersion() < 9) {
            pageLength = 6;
        }
        pageLength = Math.min(pageLength, this.param.nbLig);
        return pageLength;
    }

    private void addRow(int lig) {
        ArrayList<Object> cells = new ArrayList<Object>();
        Label dateLabel = new Label(this.param.leftPartLine.get(lig));
        dateLabel.addStyleName("big");
        dateLabel.addStyleName("align-center");
        dateLabel.setWidth(String.valueOf(this.param.largeurCol) + "px");
        cells.add(dateLabel);
        if (this.param.leftPartLine2 != null) {
            dateLabel = new Label(this.param.leftPartLine2.get(lig));
            dateLabel.addStyleName("big");
            dateLabel.addStyleName("align-center");
            dateLabel.setWidth(String.valueOf(this.param.largeurCol) + "px");
            cells.add(dateLabel);
        }
        int j = 0;
        while (j < this.param.nbCol) {
            boolean box = this.param.box[lig][j];
            CheckBox checkbox = new CheckBox();
            checkbox.setValue((Object)box);
            checkbox.addStyleName("align-center");
            checkbox.addStyleName("big");
            checkbox.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
            cells.add(checkbox);
            ++j;
        }
        this.table.addItem(cells.toArray(), (Object)new Integer(lig));
    }

    private boolean readValueInCell(CheckBox tf) {
        return (Boolean)tf.getValue();
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleSauvegarder() {
        try {
            this.updateModele();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            Notification.show((String)"Erreur de saisie");
            return;
        }
        try {
            this.performSauvegarder();
        }
        catch (OnSaveException e) {
            ArrayList<String> msgs = new ArrayList<String>();
            msgs.add("Une erreur est survenue durant la sauvegarde.");
            msgs.addAll(e.getAllMessages());
            MessagePopup.open(new MessagePopup("Erreur", msgs));
            return;
        }
        catch (ConstraintViolationException e) {
            ErrorPopup.open(e);
            return;
        }
        catch (Exception e) {
            ErrorPopup.open(e);
            return;
        }
        this.close();
    }

    private void updateModele() throws ErreurSaisieException {
        int i = 0;
        while (i < this.param.nbLig) {
            Item item = this.table.getItem((Object)new Integer(i));
            int j = 0;
            while (j < this.param.nbCol) {
                boolean val;
                CheckBox tf = (CheckBox)item.getItemProperty((Object)new Integer(j)).getValue();
                this.param.box[i][j] = val = this.readValueInCell(tf);
                ++j;
            }
            ++i;
        }
    }

    protected String checkInitialCondition() {
        return null;
    }

    private void displayErrorOnInitialCondition(String str, VerticalLayout mainLayout) {
        Label label = new Label(str, ContentMode.HTML);
        label.setStyleName("big");
        mainLayout.addComponent((Component)label);
    }
}

