/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.currencyvector;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectorUtils;
import fr.amapj.view.engine.grid.GridHeaderLine;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CurrencyVectorParam {
    public int avoirInitial;
    public int montantCible;
    public int largeurCol;
    public int espaceInterCol;
    public boolean hasColComment;
    public List<GridHeaderLine> headerLines = new ArrayList<GridHeaderLine>();
    public List<CurrencyLine> lines = new ArrayList<CurrencyLine>();
    public boolean hasSaveButton = true;
    public String libSaveButton;
    public String messageSpecifique;
    public String messageSpecifique2;
    public String messageSpecifique3;

    public void checkParam() {
        int nbAdjust = this.getNbAdjust();
        int nbEditable = this.getNbEditable();
        if (nbAdjust > 1) {
            throw new AmapjRuntimeException("Il y a 2 ou plus lignes ADJUST : nbAdjust=" + nbAdjust);
        }
        if (nbEditable == 0 && nbAdjust == 1) {
            throw new AmapjRuntimeException("Cas incoherent : nbEditable==0 && nbAdjust==1");
        }
        if (!this.hasSaveButton && nbEditable > 0) {
            throw new AmapjRuntimeException("Il y a des lignes editables et l'utilisateur ne peut pas sauvegarder");
        }
        int i = 0;
        while (i < this.lines.size()) {
            CurrencyLine line = this.lines.get(i);
            if (line.status == CurrencyLineStatus.TIRETS && line.montant != 0) {
                throw new AmapjRuntimeException("Il y a une ligne de type TIRETS avec un montant non null");
            }
            if (line.index != i) {
                throw new AmapjRuntimeException("Il y a une erreur d'index");
            }
            ++i;
        }
        if (nbAdjust == 1 && this.getMontantTotalPaiement() != this.montantCible) {
            throw new AmapjRuntimeException("Les montants initiaux ne sont pas corrects");
        }
    }

    public boolean isReadOnly() {
        for (CurrencyLine line : this.lines) {
            if (line.status != CurrencyLineStatus.EDITABLE) continue;
            return false;
        }
        return true;
    }

    public boolean hasAdjust() {
        int nb = this.getNbAdjust();
        if (nb > 1) {
            throw new AmapjRuntimeException("Il y a 2 ou plus lignes ADJUST");
        }
        return nb == 1;
    }

    public int getNbLines() {
        return this.lines.size();
    }

    private int getNbAdjust() {
        return (int)this.lines.stream().filter(e -> e.status == CurrencyLineStatus.ADJUST).count();
    }

    public int getNbEditable() {
        return (int)this.lines.stream().filter(e -> e.status == CurrencyLineStatus.EDITABLE).count();
    }

    public CurrencyLine findAdjustLine() {
        return (CurrencyLine)this.lines.stream().filter(e -> e.status == CurrencyLineStatus.ADJUST).collect(CollectorUtils.oneOrZero());
    }

    public void performAdjust() {
        CurrencyLine line = this.findAdjustLine();
        if (line == null) {
            throw new AmapjRuntimeException("Pas de ligne Adjust");
        }
        line.montant = line.montant + this.montantCible - this.getMontantTotalPaiement();
    }

    public int getMontantTotalPaiement() {
        int mnt = this.avoirInitial;
        for (CurrencyLine line : this.lines) {
            mnt += line.montant;
        }
        return mnt;
    }

    public static class CurrencyLine {
        public int index;
        public String rightPart;
        public CurrencyLineStatus status;
        public Date datePaiement;
        public int montant;
    }

    public static enum CurrencyLineStatus {
        TIRETS,
        READ_ONLY,
        EDITABLE,
        ADJUST;

    }
}

