/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.currencyvector;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.server.Page;
import com.vaadin.server.WebBrowser;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.view.engine.grid.ErreurSaisieException;
import fr.amapj.view.engine.grid.GridHeaderLine;
import fr.amapj.view.engine.grid.GridIJData;
import fr.amapj.view.engine.grid.ShortCutManager;
import fr.amapj.view.engine.grid.currencyvector.CurrencyVectorParam;
import fr.amapj.view.engine.notification.NotificationHelper;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.tools.BaseUiTools;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class PopupCurrencyVector
extends CorePopup {
    private SimpleDateFormat df = new SimpleDateFormat("d MMMMM yyyy");
    private Table table;
    protected CurrencyVectorParam param = new CurrencyVectorParam();
    private ShortCutManager shortCutManager;
    private Label montantTotalPaiement;

    public abstract void loadParam();

    public abstract void performSauvegarder() throws OnSaveException;

    @Override
    protected void createContent(VerticalLayout mainLayout) {
        Label messageSpeLabel;
        this.setType(CorePopup.PopupType.CENTERFIT);
        this.loadParam();
        this.param.checkParam();
        if (this.param.messageSpecifique != null) {
            messageSpeLabel = new Label(this.param.messageSpecifique);
            messageSpeLabel.addStyleName("popup-currency-vector-message");
            mainLayout.addComponent((Component)messageSpeLabel);
        }
        if (this.param.messageSpecifique2 != null) {
            messageSpeLabel = new Label(this.param.messageSpecifique2, ContentMode.HTML);
            messageSpeLabel.addStyleName("popup-currency-vector-message");
            mainLayout.addComponent((Component)messageSpeLabel);
        }
        if (this.param.messageSpecifique3 != null) {
            messageSpeLabel = new Label(this.param.messageSpecifique3, ContentMode.HTML);
            messageSpeLabel.addStyleName("popup-currency-vector-message");
            mainLayout.addComponent((Component)messageSpeLabel);
        }
        if (this.param.avoirInitial != 0) {
            HorizontalLayout footer1 = new HorizontalLayout();
            footer1.setWidth("350px");
            this.fillFooter(footer1, "Avoir initial", this.param.avoirInitial);
            HorizontalLayout footer2 = new HorizontalLayout();
            footer2.setWidth("200px");
            footer2.setHeight("20px");
            mainLayout.addComponent((Component)footer1);
            mainLayout.addComponent((Component)footer2);
        }
        for (GridHeaderLine line : this.param.headerLines) {
            this.constructHeaderLine(mainLayout, line);
        }
        this.table = new Table();
        this.table.addStyleName("no-vertical-lines");
        this.table.addStyleName("no-horizontal-lines");
        this.table.addStyleName("no-stripes");
        this.table.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.table.addContainerProperty((Object)new Integer(-1), Label.class, null);
        this.table.setColumnWidth((Object)new Integer(-1), this.param.largeurCol);
        Class clzz = this.param.isReadOnly() ? Label.class : TextField.class;
        this.table.addContainerProperty((Object)new Integer(0), clzz, null);
        this.table.setColumnWidth((Object)new Integer(0), this.param.largeurCol);
        if (this.param.hasColComment) {
            this.table.addContainerProperty((Object)new Integer(1), Label.class, null);
            this.table.setColumnWidth((Object)new Integer(1), this.param.largeurCol);
        }
        if (!this.param.isReadOnly()) {
            this.shortCutManager = new ShortCutManager(this.computeShortCutManager());
            this.shortCutManager.addShorcut(this.getWindow());
        }
        int i = 0;
        while (i < this.param.getNbLines()) {
            this.addRow(i);
            ++i;
        }
        this.table.setEditable(!this.param.isReadOnly());
        this.table.setSelectable(true);
        this.table.setSortEnabled(false);
        this.table.setPageLength(this.getPageLength());
        HorizontalLayout footer0 = new HorizontalLayout();
        footer0.setWidth("200px");
        footer0.setHeight("20px");
        mainLayout.addComponent((Component)this.table);
        mainLayout.addComponent((Component)footer0);
        if (!this.param.hasAdjust()) {
            HorizontalLayout footer1 = new HorizontalLayout();
            footer1.setWidth("350px");
            this.montantTotalPaiement = this.fillFooter(footer1, "Montant total paiements", this.param.getMontantTotalPaiement());
            HorizontalLayout footer2 = new HorizontalLayout();
            footer2.setWidth("200px");
            footer2.setHeight("20px");
            HorizontalLayout footer3 = new HorizontalLayout();
            footer3.setWidth("350px");
            this.fillFooter(footer3, "Montant total d\u00fb", this.param.montantCible);
            mainLayout.addComponent((Component)footer1);
            mainLayout.addComponent((Component)footer2);
            mainLayout.addComponent((Component)footer3);
        } else {
            HorizontalLayout footer1 = new HorizontalLayout();
            footer1.setWidth("350px");
            this.fillFooter(footer1, "Montant total \u00e0 r\u00e9gler", this.param.montantCible);
            mainLayout.addComponent((Component)footer1);
        }
    }

    private List<ShortCutManager.ShortCutLine> computeShortCutManager() {
        ArrayList<ShortCutManager.ShortCutLine> res = new ArrayList<ShortCutManager.ShortCutLine>();
        int i = 0;
        while (i < this.param.getNbLines()) {
            CurrencyVectorParam.CurrencyLine currencyLine = this.param.lines.get(i);
            ShortCutManager.ShortCutLine line = new ShortCutManager.ShortCutLine();
            line.isVisible = true;
            (line.editable = new boolean[1])[0] = currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.EDITABLE;
            res.add(line);
            ++i;
        }
        return res;
    }

    private Label fillFooter(HorizontalLayout footer1, String message, int montantCible) {
        Label dateLabel = new Label(message);
        dateLabel.addStyleName("prix");
        dateLabel.setSizeFull();
        footer1.addComponent((Component)dateLabel);
        footer1.setExpandRatio((Component)dateLabel, 1.0f);
        Label prixTotal = new Label(new CurrencyTextFieldConverter().convertToString(montantCible));
        prixTotal.addStyleName("prix");
        prixTotal.setSizeFull();
        footer1.addComponent((Component)prixTotal);
        footer1.setExpandRatio((Component)prixTotal, 1.0f);
        return prixTotal;
    }

    @Override
    protected void createButtonBar() {
        if (!this.param.hasSaveButton) {
            this.addButtonBlank();
            Button ok = this.addDefaultButton("OK", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
            ok.addStyleName("primary");
        } else {
            if (this.param.getNbEditable() > 1) {
                this.addButton("Copier la 1\u00e8re ligne partout", (Button.ClickListener & Serializable)e -> this.handleCopier());
            }
            this.addButtonBlank();
            this.addButton("Annuler", (Button.ClickListener & Serializable)e -> this.handleAnnuler());
            String lib = this.param.libSaveButton != null ? this.param.libSaveButton : "Sauvegarder";
            Button saveButton = this.addDefaultButton(lib, (Button.ClickListener & Serializable)e -> this.handleSauvegarder());
            saveButton.addStyleName("primary");
        }
    }

    protected void handleCopier() {
        try {
            this.doHandleCopier();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotification("Erreur de saisie sur la premiere ligne - Impossible de copier");
        }
    }

    private void doHandleCopier() throws ErreurSaisieException {
        int qteRef = 0;
        boolean found = false;
        int i = 0;
        while (i < this.param.lines.size()) {
            CurrencyVectorParam.CurrencyLine line = this.param.lines.get(i);
            if (line.status == CurrencyVectorParam.CurrencyLineStatus.EDITABLE) {
                if (!found) {
                    found = true;
                    qteRef = this.readValueInCell(i);
                } else {
                    Item item = this.table.getItem((Object)new Integer(i));
                    TextField tf = (TextField)item.getItemProperty((Object)new Integer(0)).getValue();
                    tf.setConvertedValue((Object)qteRef);
                }
            }
            ++i;
        }
    }

    private void constructHeaderLine(VerticalLayout mainLayout, GridHeaderLine line) {
        HorizontalLayout header1 = new HorizontalLayout();
        header1.setWidth(this.getLargeurTotal());
        if (line.height != -1) {
            header1.setHeight(String.valueOf(line.height) + "px");
        }
        for (GridHeaderLine.GridHeaderLineCell cell : line.cells) {
            Label dateLabel = new Label(cell.content);
            dateLabel.addStyleName("tete");
            header1.addComponent((Component)dateLabel);
            dateLabel.setSizeFull();
            header1.setExpandRatio((Component)dateLabel, 1.0f);
        }
        mainLayout.addComponent((Component)header1);
    }

    private int getPageLength() {
        Page page = UI.getCurrent().getPage();
        int pageLength = 15;
        int lineHeight = this.param.isReadOnly() ? 26 : 32;
        int headerAndButtonHeight = BaseUiTools.isCompactMode() ? 270 : 365;
        int maxLineAvailable = (page.getBrowserWindowHeight() - headerAndButtonHeight) / lineHeight;
        maxLineAvailable = Math.max(maxLineAvailable, 4);
        pageLength = Math.min(pageLength, maxLineAvailable);
        WebBrowser webBrowser = UI.getCurrent().getPage().getWebBrowser();
        if (webBrowser.isIE() && webBrowser.getBrowserMajorVersion() < 9) {
            pageLength = Math.min(pageLength, 6);
        }
        pageLength = Math.min(pageLength, this.param.getNbLines());
        return pageLength;
    }

    private String getLargeurTotal() {
        int nbCol = 2;
        if (this.param.hasColComment) {
            ++nbCol;
        }
        return String.valueOf(nbCol * (this.param.largeurCol + this.param.espaceInterCol)) + "px";
    }

    private void addRow(int lig) {
        TextField tf;
        CurrencyVectorParam.CurrencyLine currencyLine = this.param.lines.get(lig);
        ArrayList<Object> cells = new ArrayList<Object>();
        Label dateLabel = new Label(this.df.format(currencyLine.datePaiement));
        dateLabel.addStyleName("date-saisie");
        dateLabel.setWidth(String.valueOf(this.param.largeurCol) + "px");
        cells.add(dateLabel);
        int qte = currencyLine.montant;
        if (this.param.isReadOnly()) {
            String txt;
            if (currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.TIRETS) {
                txt = "----";
            } else if (currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.READ_ONLY || currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.ADJUST) {
                txt = qte == 0 ? "" : new CurrencyTextFieldConverter().convertToString(qte);
            } else {
                throw new AmapjRuntimeException();
            }
            Label tf2 = new Label(txt);
            tf2.addStyleName("cell-voir");
            tf2.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
            cells.add(tf2);
        } else if (currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.TIRETS) {
            tf = new TextField();
            tf.setValue("----");
            tf.setEnabled(false);
            tf.addStyleName("cell-voir");
            tf.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
            cells.add(tf);
        } else if (currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.READ_ONLY) {
            tf = BaseUiTools.createCurrencyField("", true);
            tf.setConvertedValue((Object)new Integer(qte));
            tf.setEnabled(false);
            tf.addStyleName("cell-voir");
            tf.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
            cells.add(tf);
        } else if (currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.EDITABLE) {
            tf = BaseUiTools.createCurrencyField("", false);
            tf.setData((Object)new GridIJData(lig, 0));
            tf.setConvertedValue((Object)new Integer(qte));
            tf.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleUpdateModele());
            tf.addStyleName("cell-saisie");
            tf.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
            this.shortCutManager.registerTextField(tf);
            cells.add(tf);
        } else if (currencyLine.status == CurrencyVectorParam.CurrencyLineStatus.ADJUST) {
            tf = BaseUiTools.createCurrencyField("", true);
            tf.setData((Object)new GridIJData(lig, 0));
            tf.setConvertedValue((Object)new Integer(qte));
            tf.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleUpdateModele());
            tf.addStyleName("cell-saisie");
            tf.setWidth(String.valueOf(this.param.largeurCol - 10) + "px");
            this.shortCutManager.registerTextField(tf);
            cells.add(tf);
            tf.setEnabled(false);
        } else {
            throw new AmapjRuntimeException();
        }
        if (this.param.hasColComment) {
            Label rightLabel = new Label(currencyLine.rightPart);
            rightLabel.addStyleName("date-saisie");
            rightLabel.setWidth(String.valueOf(this.param.largeurCol) + "px");
            cells.add(rightLabel);
        }
        this.table.addItem(cells.toArray(), (Object)new Integer(lig));
    }

    private void handleUpdateModele() {
        try {
            this.updateModele();
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotificationMontant();
        }
    }

    private TextField getTextField(int lineIndex) throws ErreurSaisieException {
        Item item = this.table.getItem((Object)new Integer(lineIndex));
        TextField tf = (TextField)item.getItemProperty((Object)new Integer(0)).getValue();
        return tf;
    }

    private int readValueInCell(int lineIndex) throws ErreurSaisieException {
        TextField tf = this.getTextField(lineIndex);
        try {
            Integer val = (Integer)tf.getConvertedValue();
            int qte = 0;
            if (val != null) {
                qte = val;
            }
            return qte;
        }
        catch (Converter.ConversionException conversionException) {
            throw new ErreurSaisieException();
        }
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleSauvegarder() {
        try {
            if (!this.param.isReadOnly()) {
                this.updateModele();
            }
        }
        catch (ErreurSaisieException erreurSaisieException) {
            NotificationHelper.displayNotificationMontant();
            return;
        }
        try {
            this.performSauvegarder();
        }
        catch (OnSaveException e) {
            e.showInNewDialogBox();
            return;
        }
        this.close();
    }

    private void updateModele() throws ErreurSaisieException {
        CurrencyVectorParam.CurrencyLine line2;
        int cumul = this.param.avoirInitial;
        for (CurrencyVectorParam.CurrencyLine line2 : this.param.lines) {
            int qte;
            if (line2.status != CurrencyVectorParam.CurrencyLineStatus.EDITABLE) continue;
            line2.montant = qte = this.readValueInCell(line2.index);
            cumul += qte;
        }
        line2 = this.param.findAdjustLine();
        if (line2 != null) {
            this.param.performAdjust();
            TextField tf = this.getTextField(line2.index);
            tf.setConvertedValue((Object)line2.montant);
        }
        if (this.montantTotalPaiement != null) {
            this.montantTotalPaiement.setValue(new CurrencyTextFieldConverter().convertToString(this.param.getMontantTotalPaiement()));
        }
    }
}

