/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.grid.integergrid.lignecumul;

import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.grid.integergrid.IntegerGridLine;
import fr.amapj.view.engine.grid.integergrid.IntegerGridParam;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;

public class LigneCumulManager {
    private IntegerGridParam param;
    private Label prixTotal;
    private boolean isPresent;
    private String libLigneCumul;
    private int indexLine;

    public LigneCumulManager(IntegerGridParam param) {
        this.param = param;
        this.libLigneCumul = param.ligneCumulParam.libCustomLigneCumul != null ? param.ligneCumulParam.libCustomLigneCumul : "Montant total";
        switch (param.ligneCumulParam.ligneCumul) {
            case NO: {
                this.isPresent = false;
                break;
            }
            case STD: {
                this.isPresent = true;
                this.indexLine = -1;
                break;
            }
            case FIRST_LINE: {
                this.indexLine = this.findIndexLine();
                this.isPresent = this.indexLine != -2;
                break;
            }
        }
    }

    private int findIndexLine() {
        int i = 0;
        while (i < this.param.lines.size()) {
            IntegerGridLine line = this.param.lines.get(i);
            if (line.isVisible) {
                return i;
            }
            ++i;
        }
        return -2;
    }

    public void createContent(VerticalLayout mainLayout) {
        if (this.isPresent) {
            HorizontalLayout footer1 = new HorizontalLayout();
            Label dateLabel = new Label(this.libLigneCumul);
            dateLabel.addStyleName("libprix");
            footer1.addComponent((Component)dateLabel);
            this.prixTotal = new Label("");
            this.displayMontantTotal();
            this.prixTotal.addStyleName("prix");
            this.prixTotal.setWidth("100px");
            footer1.addComponent((Component)this.prixTotal);
            mainLayout.addComponent((Component)footer1);
        }
    }

    public void displayMontantTotal() {
        if (this.isPresent) {
            int mnt = 0;
            mnt = this.indexLine == -1 ? this.param.getMontantTotal() : this.param.getMontantOfLine(this.indexLine);
            this.prixTotal.setValue(new CurrencyTextFieldConverter().convertToString(mnt));
        }
    }
}

