/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.menu;

import com.vaadin.navigator.View;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.model.models.param.paramecran.PELivraisonAmapien;
import fr.amapj.model.models.param.paramecran.PEReceptionCheque;
import fr.amapj.model.models.param.paramecran.PERemiseProducteur;
import fr.amapj.model.models.param.paramecran.common.AbstractParamEcran;
import fr.amapj.model.models.param.paramecran.common.ParamEcranConverter;
import fr.amapj.model.models.param.paramecran.producteur.PELivraisonProducteur;
import fr.amapj.service.services.advanced.tenantnotification.TenantNotificationService;
import fr.amapj.service.services.parametres.ParamEcranDTO;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.menu.MenuDescription;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.menu.ModuleList;
import fr.amapj.view.views.advanced.devtools.DevToolsView;
import fr.amapj.view.views.advanced.maintenance.MaintenanceView;
import fr.amapj.view.views.advanced.supervision.SupervisionView;
import fr.amapj.view.views.advanced.tenantnotification.TenantNotificationListPart;
import fr.amapj.view.views.appinstance.AppInstanceListPart;
import fr.amapj.view.views.archivage.contrat.ArchivageContratListPart;
import fr.amapj.view.views.archivage.gestion.GestionArchivageView;
import fr.amapj.view.views.archivage.producteur.ArchivageProducteurListPart;
import fr.amapj.view.views.archivage.utilisateur.ArchivageUtilisateurListPart;
import fr.amapj.view.views.compte.MonCompteView;
import fr.amapj.view.views.contratsamapien.ContratsAmapienListPart;
import fr.amapj.view.views.cotisation.bilan.BilanCotisationView;
import fr.amapj.view.views.cotisation.reception.ReceptionCotisationView;
import fr.amapj.view.views.droits.DroitsAdministrateurListPart;
import fr.amapj.view.views.droits.DroitsTresorierListPart;
import fr.amapj.view.views.editionspe.EditionSpeListPart;
import fr.amapj.view.views.gestioncontrat.listpart.GestionContratListPart;
import fr.amapj.view.views.gestioncontratsignes.GestionContratSignesListPart;
import fr.amapj.view.views.historiquecontrats.HistoriqueContratsView;
import fr.amapj.view.views.historiquepaiements.HistoriquePaiementsView;
import fr.amapj.view.views.importdonnees.ImportDonneesView;
import fr.amapj.view.views.listeadherents.ListeAdherentsView;
import fr.amapj.view.views.listeproducteurreferent.ListeProducteurReferentView;
import fr.amapj.view.views.livraisonamapien.LivraisonAmapienView;
import fr.amapj.view.views.logview.LogView;
import fr.amapj.view.views.logview.StatAccessView;
import fr.amapj.view.views.mesadhesions.MesAdhesionsView;
import fr.amapj.view.views.mescontrats.MesContratsView;
import fr.amapj.view.views.meslivraisons.MesLivraisonsView;
import fr.amapj.view.views.mespaiements.MesPaiementsView;
import fr.amapj.view.views.parametres.ParametresView;
import fr.amapj.view.views.permanence.detailperiode.DetailPeriodePermanenceListPart;
import fr.amapj.view.views.permanence.mespermanences.MesPermanencesView;
import fr.amapj.view.views.permanence.periode.PeriodePermanenceListPart;
import fr.amapj.view.views.permanence.permanencerole.PermanenceRoleListPart;
import fr.amapj.view.views.producteur.basicform.ProducteurListPart;
import fr.amapj.view.views.producteur.contrats.ProducteurContratListPart;
import fr.amapj.view.views.producteur.livraison.ProducteurLivraisonsView;
import fr.amapj.view.views.produit.ProduitListPart;
import fr.amapj.view.views.receptioncheque.ReceptionChequeListPart;
import fr.amapj.view.views.remiseproducteur.RemiseProducteurListPart;
import fr.amapj.view.views.sendmail.SendMailView;
import fr.amapj.view.views.suiviacces.SuiviAccesView;
import fr.amapj.view.views.synthesemulticontrat.SyntheseMultiContratView;
import fr.amapj.view.views.utilisateur.UtilisateurListPart;
import fr.amapj.view.views.visiteamap.VisiteAmapView;
import java.util.ArrayList;
import java.util.List;

public class MenuInfo {
    private List<MenuDescription> menus = new ArrayList<MenuDescription>();
    private ParametresDTO param;
    private List<ParamEcranDTO> dtos;
    private List<RoleList> roles;

    public List<MenuDescription> getMenu() {
        this.menus = new ArrayList<MenuDescription>();
        this.param = new ParametresService().getParametres();
        this.dtos = new ParametresService().getAllParamEcranDTO();
        this.roles = SessionManager.getSessionParameters().userRole;
        if (this.hasRole(RoleList.MASTER)) {
            this.addCategorie("MASTER");
            this.addMenu(MenuList.LISTE_APP_INSTANCE, AppInstanceListPart.class);
            this.addMenu(MenuList.SUIVI_ACCES, SuiviAccesView.class);
            this.addMenu(MenuList.VISU_LOG, LogView.class);
            this.addMenu(MenuList.STAT_ACCES, StatAccessView.class);
            this.addMenu(MenuList.SUPERVISION, SupervisionView.class);
            this.addMenu(MenuList.OUTILS_DEV, DevToolsView.class);
            this.addCategorie("DIVERS");
            this.addMenu(MenuList.UTILISATEUR, UtilisateurListPart.class);
            this.addMenu(MenuList.PARAMETRES, ParametresView.class);
            this.addMenu(MenuList.ENVOI_MAIL, SendMailView.class);
            return this.menus;
        }
        this.addMenu(MenuList.MES_CONTRATS, MesContratsView.class);
        this.addMenu(MenuList.MES_LIVRAISONS, MesLivraisonsView.class);
        this.addMenu(MenuList.MES_PAIEMENTS, MesPaiementsView.class);
        this.addMenu(MenuList.MES_ADHESIONS, MesAdhesionsView.class, ModuleList.GESTION_COTISATION);
        this.addMenu(MenuList.MON_COMPTE, MonCompteView.class);
        this.addMenu(MenuList.VISITE_AMAP, VisiteAmapView.class);
        this.addMenu(MenuList.LISTE_PRODUCTEUR_REFERENT, ListeProducteurReferentView.class);
        this.addMenu(MenuList.LISTE_ADHERENTS, ListeAdherentsView.class);
        this.addMenu(MenuList.MES_PERMANENCES, MesPermanencesView.class, ModuleList.PLANNING_DISTRIBUTION);
        this.addCategorie("HISTORIQUE");
        this.addMenu(MenuList.HISTORIQUE_CONTRATS, HistoriqueContratsView.class);
        this.addMenu(MenuList.HISTORIQUE_PAIEMENTS, HistoriquePaiementsView.class);
        this.addCategorie("EXTRA");
        if (this.extraLivraisonAmapien()) {
            this.addMenu(MenuList.LIVRAISON_AMAPIEN, LivraisonAmapienView.class);
        }
        if (this.extraLivraisonProducteur()) {
            this.addMenu(MenuList.LIVRAISONS_PRODUCTEUR, ProducteurLivraisonsView.class);
        }
        if (this.hasRole(RoleList.PRODUCTEUR)) {
            this.addCategorie("PRODUCTEUR");
            this.addMenu(MenuList.LIVRAISONS_PRODUCTEUR, ProducteurLivraisonsView.class);
            this.addMenu(MenuList.CONTRATS_PRODUCTEUR, ProducteurContratListPart.class);
            if (this.producteurCanAccessReceptionCheque()) {
                this.addMenu(MenuList.RECEPTION_CHEQUES, ReceptionChequeListPart.class);
            }
            if (this.producteurCanAccessRemiseProducteur()) {
                this.addMenu(MenuList.REMISE_PRODUCTEUR, RemiseProducteurListPart.class);
            }
        }
        if (this.hasRole(RoleList.REFERENT)) {
            this.addCategorie("REFERENT");
            this.addMenu(MenuList.GESTION_CONTRAT, GestionContratListPart.class);
            this.addMenu(MenuList.GESTION_CONTRAT_SIGNES, GestionContratSignesListPart.class);
            this.addMenu(MenuList.RECEPTION_CHEQUES, ReceptionChequeListPart.class);
            this.addMenu(MenuList.REMISE_PRODUCTEUR, RemiseProducteurListPart.class);
            this.addMenu(MenuList.PRODUIT, ProduitListPart.class);
            this.addMenu(MenuList.CONTRATS_AMAPIEN, ContratsAmapienListPart.class);
            this.addMenu(MenuList.LIVRAISON_AMAPIEN, LivraisonAmapienView.class);
            this.addMenu(MenuList.SYNTHESE_MULTI_CONTRAT, SyntheseMultiContratView.class);
        }
        if (this.hasRole(RoleList.REFERENT) && this.hasModule(ModuleList.PLANNING_DISTRIBUTION)) {
            this.addCategorie("PERMANENCES");
            this.addMenu(MenuList.PERIODE_PERMANENCE, PeriodePermanenceListPart.class);
            this.addMenu(MenuList.DETAIL_PERIODE_PERMANENCE, DetailPeriodePermanenceListPart.class);
            this.addMenu(MenuList.ROLE_PERMANENCE, PermanenceRoleListPart.class);
        }
        if (this.hasRole(RoleList.TRESORIER)) {
            this.addCategorie("TRESORIER");
            this.addMenu(MenuList.UTILISATEUR, UtilisateurListPart.class);
            this.addMenu(MenuList.PRODUCTEUR, ProducteurListPart.class);
            this.addMenu(MenuList.BILAN_COTISATION, BilanCotisationView.class, ModuleList.GESTION_COTISATION);
            this.addMenu(MenuList.RECEPTION_COTISATION, ReceptionCotisationView.class, ModuleList.GESTION_COTISATION);
            this.addMenu(MenuList.IMPORT_DONNEES, ImportDonneesView.class);
            this.addMenu(MenuList.LISTE_TRESORIER, DroitsTresorierListPart.class);
            this.addMenu(MenuList.ETIQUETTE, EditionSpeListPart.class);
            if (new TenantNotificationService().isActif()) {
                this.addMenu(MenuList.TENANT_NOTIFICATION, TenantNotificationListPart.class);
            }
        }
        if (this.hasRole(RoleList.REFERENT)) {
            this.addCategorie("ARCHIVES");
            this.addMenu(MenuList.CONTRAT_ARCHIVE, ArchivageContratListPart.class);
            if (this.hasRole(RoleList.TRESORIER)) {
                this.addMenu(MenuList.PRODUCTEUR_ARCHIVE, ArchivageProducteurListPart.class);
                this.addMenu(MenuList.UTILISATEUR_ARCHIVE, ArchivageUtilisateurListPart.class);
                this.addMenu(MenuList.GESTION_ARCHIVE, GestionArchivageView.class);
            }
        }
        if (this.hasRole(RoleList.ADMIN)) {
            this.addCategorie("ADMIN");
            this.addMenu(MenuList.PARAMETRES, ParametresView.class);
            this.addMenu(MenuList.LISTE_ADMIN, DroitsAdministrateurListPart.class);
            this.addMenu(MenuList.MAINTENANCE, MaintenanceView.class);
            this.addMenu(MenuList.ENVOI_MAIL, SendMailView.class);
        }
        this.removeEmptyCategories();
        return this.menus;
    }

    private boolean extraLivraisonAmapien() {
        ParamEcranDTO dto = this.findParamEcran(MenuList.LIVRAISON_AMAPIEN);
        if (dto == null) {
            return false;
        }
        PELivraisonAmapien ape = (PELivraisonAmapien)ParamEcranConverter.load(dto);
        return ape.accesEcran == PELivraisonAmapien.PELivraisonAmapienAccess.ALL;
    }

    private boolean extraLivraisonProducteur() {
        ParamEcranDTO dto = this.findParamEcran(MenuList.LIVRAISONS_PRODUCTEUR);
        if (dto == null) {
            return false;
        }
        PELivraisonProducteur ape = (PELivraisonProducteur)ParamEcranConverter.load(dto);
        return ape.accesEcran == PELivraisonProducteur.PELivraisonProducteurAccess.ALL;
    }

    private boolean producteurCanAccessReceptionCheque() {
        ParamEcranDTO dto = this.findParamEcran(MenuList.RECEPTION_CHEQUES);
        if (dto == null) {
            return false;
        }
        PEReceptionCheque ape = (PEReceptionCheque)ParamEcranConverter.load(dto);
        return ape.accesEcran == PEReceptionCheque.PEReceptionChequeAccess.PRODUCTEUR;
    }

    private boolean producteurCanAccessRemiseProducteur() {
        ParamEcranDTO dto = this.findParamEcran(MenuList.REMISE_PRODUCTEUR);
        if (dto == null) {
            return false;
        }
        PERemiseProducteur ape = (PERemiseProducteur)ParamEcranConverter.load(dto);
        return ape.accesEcran == PERemiseProducteur.PERemiseProducteurAccess.PRODUCTEUR;
    }

    private void addCategorie(String categorie) {
        this.menus.add(new MenuDescription(categorie));
    }

    private void addMenu(MenuList menu, Class<? extends View> viewClass) {
        if (this.complyParamEcran(menu)) {
            this.menus.add(new MenuDescription(menu, viewClass));
        }
    }

    private void addMenu(MenuList menu, Class<? extends View> viewClass, ModuleList module) {
        if (this.hasModule(module)) {
            this.addMenu(menu, viewClass);
        }
    }

    private boolean hasRole(RoleList role) {
        return this.roles.contains((Object)role);
    }

    private boolean hasModule(ModuleList module) {
        switch (module) {
            case PLANNING_DISTRIBUTION: {
                return this.param.etatPlanningDistribution.equals((Object)EtatModule.ACTIF);
            }
            case GESTION_COTISATION: {
                return this.param.etatGestionCotisation.equals((Object)EtatModule.ACTIF);
            }
        }
        throw new AmapjRuntimeException("Erreur de programmation");
    }

    private boolean complyParamEcran(MenuList menu) {
        ParamEcranDTO dto = this.findParamEcran(menu);
        if (dto == null) {
            return true;
        }
        AbstractParamEcran ape = ParamEcranConverter.load(dto);
        return ape.complyParamEcan(this.roles);
    }

    private ParamEcranDTO findParamEcran(MenuList menu) {
        for (ParamEcranDTO dto : this.dtos) {
            if (!dto.menu.equals((Object)menu)) continue;
            return dto;
        }
        return null;
    }

    private void removeEmptyCategories() {
        ArrayList<MenuDescription> toRemoves = new ArrayList<MenuDescription>();
        int i = 0;
        while (i < this.menus.size()) {
            MenuDescription menu = this.menus.get(i);
            if (menu.getCategorie() != null && (i == this.menus.size() - 1 || this.menus.get(i + 1).getCategorie() != null)) {
                toRemoves.add(menu);
            }
            ++i;
        }
        this.menus.removeAll(toRemoves);
    }
}

