/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.menu;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.UI;
import fr.amapj.service.services.advanced.tenantnotification.TenantNotificationService;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.session.SessionParameters;
import fr.amapj.view.engine.menu.MenuDescription;
import fr.amapj.view.engine.menu.MenuInfo;
import fr.amapj.view.engine.popup.tenantnotificationpopup.OnStartTenantNotificationPopup;
import fr.amapj.view.engine.ui.AmapUI;
import fr.amapj.view.engine.ui.ValoMenuLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuPart {
    private static final Logger logger = LogManager.getLogger();
    private Map<String, Button> viewNameToMenuButton;

    public void buildMainView(AmapUI ui, ValoMenuLayout root) {
        root.prepareForMainPage();
        this.viewNameToMenuButton = new HashMap<String, Button>();
        final CssLayout menu = new CssLayout();
        CssLayout menuItemsLayout = new CssLayout();
        if (ui.getPage().getWebBrowser().isIE() && ui.getPage().getWebBrowser().getBrowserMajorVersion() == 9) {
            menu.setWidth("320px");
        }
        List<MenuDescription> allMenus = new MenuInfo().getMenu();
        Navigator nav = new Navigator((UI)ui, root.getContentContainer());
        nav.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                logger.info("Entr\u00e9e dans l'\u00e9cran {}", (Object)event.getViewName());
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                menu.removeStyleName("valo-menu-visible");
            }
        });
        if (allMenus.size() > 0) {
            MenuDescription first = allMenus.get(0);
            nav.setErrorView(first.getViewClass());
        }
        for (MenuDescription mD : allMenus) {
            if (mD.getCategorie() != null) continue;
            nav.addView("/" + mD.getMenuName().name().toLowerCase(), mD.getViewClass());
        }
        root.addMenu((Component)this.buildMenu(menu, menuItemsLayout, allMenus, nav, ui));
        if (new TenantNotificationService().hasNewNotification()) {
            new OnStartTenantNotificationPopup(nav).open();
        }
    }

    private CssLayout buildMenu(final CssLayout menu, final CssLayout menuItemsLayout, List<MenuDescription> allMenus, final Navigator navigator, final AmapUI ui) {
        HorizontalLayout top = new HorizontalLayout();
        top.setWidth("100%");
        top.setDefaultComponentAlignment(Alignment.MIDDLE_LEFT);
        top.addStyleName("valo-menu-title");
        menu.addComponent((Component)top);
        Button showMenu = new Button("Menu", new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (menu.getStyleName().contains("valo-menu-visible")) {
                    menu.removeStyleName("valo-menu-visible");
                } else {
                    menu.addStyleName("valo-menu-visible");
                }
            }
        });
        showMenu.addStyleName("primary");
        showMenu.addStyleName("small");
        showMenu.addStyleName("valo-menu-toggle");
        showMenu.setIcon((Resource)FontAwesome.LIST);
        menu.addComponent((Component)showMenu);
        String nomAmap = new ParametresService().getParametres().nomAmap;
        Label title = new Label("<h2>" + nomAmap + "</h2>", ContentMode.HTML);
        title.setSizeUndefined();
        top.addComponent((Component)title);
        top.setExpandRatio((Component)title, 1.0f);
        MenuBar settings = new MenuBar();
        settings.addStyleName("user-menu");
        SessionParameters p = SessionManager.getSessionParameters();
        MenuBar.MenuItem settingsItem = settings.addItem(String.valueOf(p.userPrenom) + " " + p.userNom, null, null);
        settingsItem.addItem("Se d\u00e9connecter", new MenuBar.Command(){

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                new PasswordManager().disconnect();
                ui.buildLoginView(null, null, null);
            }
        });
        menu.addComponent((Component)settings);
        menuItemsLayout.setPrimaryStyleName("valo-menuitems");
        menu.addComponent((Component)menuItemsLayout);
        boolean first = true;
        String firstEntry = null;
        Button firstButton = null;
        for (MenuDescription menuDescription : allMenus) {
            if (menuDescription.getCategorie() != null) {
                Label l = new Label(menuDescription.getCategorie(), ContentMode.HTML);
                l.setPrimaryStyleName("valo-menu-subtitle");
                l.addStyleName("h4");
                l.setSizeUndefined();
                menuItemsLayout.addComponent((Component)l);
                continue;
            }
            final String view = menuDescription.getMenuName().name().toLowerCase();
            String titleView = menuDescription.getMenuName().getTitle();
            Button b = new Button(titleView, new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    MenuPart.this.setSelected(event.getButton(), menuItemsLayout);
                    navigator.navigateTo("/" + view);
                }
            });
            b.setId("amapj.menu." + view);
            b.setHtmlContentAllowed(true);
            b.setPrimaryStyleName("valo-menu-item");
            b.setIcon((Resource)menuDescription.getMenuName().getFont());
            menuItemsLayout.addComponent((Component)b);
            this.viewNameToMenuButton.put("/" + view, b);
            if (!first) continue;
            first = false;
            firstButton = b;
            firstEntry = view;
        }
        String f = Page.getCurrent().getUriFragment();
        if (f != null && f.startsWith("!")) {
            f = f.substring(1);
        }
        if (f == null || f.equals("") || f.equals("/")) {
            this.navigateWithProtect(navigator, "/" + firstEntry);
            this.setSelected(firstButton, menuItemsLayout);
        } else {
            this.navigateWithProtect(navigator, f);
            this.setSelected(this.viewNameToMenuButton.get(f), menuItemsLayout);
        }
        return menu;
    }

    private void navigateWithProtect(Navigator navigator, String navigationState) {
        try {
            navigator.navigateTo(navigationState);
        }
        catch (Exception e) {
            logger.error("Erreur lors du chargement de la premi\u00e8re page", (Throwable)e);
        }
    }

    private void setSelected(Button b, CssLayout menuItemsLayout) {
        Iterator it = menuItemsLayout.iterator();
        while (it.hasNext()) {
            ((Component)it.next()).removeStyleName("selected");
        }
        if (b != null) {
            b.addStyleName("selected");
        }
    }
}

