/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.cascadingpopup;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.cascadingpopup.CInfo;
import fr.amapj.view.engine.popup.cascadingpopup.CascadingData;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import java.util.Arrays;
import java.util.List;

public class CascadingPopup {
    private PopupListener finalListener;
    private CascadingData data;
    private boolean startDone = false;

    public CascadingPopup(PopupListener finalListener, CascadingData data) {
        this.finalListener = finalListener;
        this.data = data;
    }

    public void start(CInfo info) {
        if (this.startDone) {
            throw new AmapjRuntimeException("Il est interdit d'appeler deux fois la fonction start");
        }
        this.startDone = true;
        this.openNextPopup(info);
    }

    private void openNextPopup(CInfo info) {
        if (info == null) {
            this.callFinalListener();
            return;
        }
        if (info.popup == null) {
            this.data.validate();
            this.endOfPopup(info);
            return;
        }
        this.data.shouldContinue = false;
        this.data.libSaveButton = info.libSaveButton;
        this.data.currentPopup = info.popup;
        CorePopup.open(info.popup, () -> this.endOfPopup(info));
    }

    private void endOfPopup(CInfo info) {
        CorePopup insertedPopup = this.data.insertedPopup;
        if (insertedPopup != null) {
            this.data.insertedPopup = null;
            this.data.currentPopup = insertedPopup;
            info.popup = insertedPopup;
            CorePopup.open(info.popup, () -> this.endOfPopup(info));
            return;
        }
        if (this.data.shouldContinue()) {
            if (info.actionAfterOnSaveButton != null) {
                try {
                    info.actionAfterOnSaveButton.action();
                }
                catch (OnSaveException e) {
                    this.displayError(e.getAllMessages());
                    return;
                }
            }
            if (info.onSuccess == null) {
                this.callFinalListener();
                return;
            }
            CInfo nextInfo = info.onSuccess.get();
            this.openNextPopup(nextInfo);
        } else {
            if (info.onFail == null) {
                this.callFinalListener();
                return;
            }
            CInfo nextInfo = info.onFail.get();
            this.openNextPopup(nextInfo);
        }
    }

    private void callFinalListener() {
        if (this.finalListener != null) {
            this.finalListener.onPopupClose();
        }
    }

    public void displayError(List<String> msgs) {
        MessagePopup p = new MessagePopup("Impossible de continuer", msgs);
        p.open(() -> this.callFinalListener());
    }

    public void displayError(String msg) {
        this.displayError(Arrays.asList(msg));
    }
}

