/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.errorpopup;

import com.vaadin.server.ServerRpcManager;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjException;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.StackUtils;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.session.SessionParameters;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import java.io.Serializable;
import javax.validation.ConstraintViolationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorPopup
extends CorePopup {
    private static final Logger logger = LogManager.getLogger();
    private String okButtonTitle = "OK";
    private String message;
    private Throwable throwable;

    public ErrorPopup(String message) {
        this(message, null);
    }

    public ErrorPopup(String message, Throwable throwable) {
        this.message = message;
        this.throwable = throwable;
        this.popupTitle = "Erreur";
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.setColorStyle(CorePopup.ColorStyle.RED);
        SessionParameters p = SessionManager.getSessionParameters();
        String debugMessage = null;
        if (p != null) {
            debugMessage = String.valueOf(p.userNom) + " " + p.userPrenom + " a rencontr\u00e9 une erreur :" + this.message;
            p.incNbError();
        } else {
            debugMessage = "Pas d'utilisateur encore logg\u00e9. Erreur :" + this.message;
        }
        logger.info(debugMessage, this.throwable);
        String constraintInfo = this.getConstraintInfo(this.throwable);
        if (constraintInfo != null) {
            logger.info("Constraint Information:" + constraintInfo);
        }
        String msg = "D\u00e9sol\u00e9, une erreur est survenue.<br/>";
        if (this.message != null) {
            msg = String.valueOf(msg) + "Information suppl\u00e9mentaire:<br/>" + this.message + "<br/>";
        }
        if (constraintInfo != null) {
            msg = String.valueOf(msg) + "<br/>" + constraintInfo + "<br/>";
        }
        msg = String.valueOf(msg) + "Veuillez cliquer sur OK pour continuer<br/>";
        HorizontalLayout hlTexte = new HorizontalLayout();
        hlTexte.setMargin(true);
        hlTexte.setSpacing(true);
        hlTexte.setWidth("100%");
        Label textArea = new Label(msg, ContentMode.HTML);
        textArea.setStyleName("big");
        textArea.setWidth("80%");
        hlTexte.addComponent((Component)textArea);
        hlTexte.setExpandRatio((Component)textArea, 1.0f);
        hlTexte.setComponentAlignment((Component)textArea, Alignment.MIDDLE_CENTER);
        contentLayout.addComponent((Component)hlTexte);
    }

    private String getConstraintInfo(Throwable t) {
        if (t instanceof ConstraintViolationException) {
            ConstraintViolationException e = (ConstraintViolationException)t;
            return StackUtils.getConstraints(e);
        }
        if (t.getCause() != null) {
            return this.getConstraintInfo(t.getCause());
        }
        return null;
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.addDefaultButton(this.okButtonTitle, (Button.ClickListener & Serializable)e -> this.handleOK());
    }

    protected void handleOK() {
        this.close();
    }

    public static void open(Throwable throwable) {
        String msg = ErrorPopup.findMessage(throwable);
        ErrorPopup.open(new ErrorPopup(msg, throwable));
    }

    private static String findMessage(Throwable t) {
        if (t instanceof AmapjRuntimeException || t instanceof AmapjException) {
            return t.getMessage();
        }
        if (t instanceof ServerRpcManager.RpcInvocationException) {
            t = t.getCause();
            while (t != null) {
                if (t instanceof AmapjRuntimeException || t instanceof AmapjException) {
                    return t.getMessage();
                }
                t = t.getCause();
            }
        }
        return null;
    }

    public static void open(String message, Throwable throwable) {
        ErrorPopup.open(new ErrorPopup(message, throwable));
    }

    public static void open(String message) {
        ErrorPopup.open(new ErrorPopup(message));
    }
}

