/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.fieldlink;

import com.vaadin.data.Property;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.ComboBox;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.view.engine.popup.formpopup.ValidatorManager;
import fr.amapj.view.engine.popup.formpopup.fieldlink.part.ComponentFieldLinkPart;
import fr.amapj.view.engine.popup.formpopup.fieldlink.part.FieldLinkPart;
import fr.amapj.view.engine.popup.formpopup.fieldlink.part.StdFieldLinkPart;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidatorConditionnalFieldLink;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FieldLink {
    private ComboBox box;
    private List<FieldLinkPart<?>> fields = new ArrayList();
    private NotNullValidatorConditionnalFieldLink notNull;
    private List<Enum<?>> actives = new ArrayList();
    private ValidatorManager validatorManager;
    private boolean currentState;
    private FieldLink parent;
    private boolean doInvisible;

    public FieldLink(ValidatorManager validatorManager, List<Enum<?>> actives, ComboBox box) {
        this(validatorManager, actives, box, false);
    }

    public FieldLink(ValidatorManager validatorManager, List<Enum<?>> actives, ComboBox box, boolean doInvisible) {
        this.validatorManager = validatorManager;
        this.actives = actives;
        this.box = box;
        this.doInvisible = doInvisible;
        this.notNull = new NotNullValidatorConditionnalFieldLink();
        this.notNull.checkIf(this);
        box.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.valueChanged());
    }

    public IValidator getValidator() {
        return this.notNull;
    }

    public void doLink() {
        if (this.parent != null) {
            throw new AmapjRuntimeException("Cette m\u00e9thode doit etre appel\u00e9e uniquement sur la racine");
        }
        this.initialize();
    }

    private void initialize() {
        this.currentState = this.isActif();
        for (FieldLinkPart<?> fd : this.fields) {
            fd.enableField(this.currentState);
            if (!this.currentState) {
                fd.setDefaultValueOnDesactivate();
            }
            if (fd.getFieldLink() == null) continue;
            fd.getFieldLink().initialize();
        }
    }

    public boolean isActif() {
        if (this.parent != null && !this.parent.currentState) {
            return false;
        }
        Enum en = (Enum)this.box.getValue();
        return this.actives.contains(en);
    }

    public <T> void addField(AbstractField<T> f) {
        this.addField(f, null, null);
    }

    public <T> void addField(AbstractField<T> f, T defaultValueOnActivate, T defaultValueOnDesactivate) {
        this.addField(f, defaultValueOnActivate, defaultValueOnDesactivate, null);
    }

    public <T> void addField(FieldLink fieldLink, T defaultValueOnActivate, T defaultValueOnDesactivate) {
        fieldLink.parent = this;
        this.addField((AbstractField<T>)fieldLink.box, defaultValueOnActivate, defaultValueOnDesactivate, fieldLink);
    }

    private <T> void addField(AbstractField<T> field, T defaultValueOnActivate, T defaultValueOnDesactivate, FieldLink fieldLink) {
        StdFieldLinkPart<T> fd = new StdFieldLinkPart<T>(field, defaultValueOnActivate, defaultValueOnDesactivate, fieldLink, this.doInvisible);
        this.fields.add(fd);
    }

    public void addComponent(AbstractComponent component) {
        ComponentFieldLinkPart fd = new ComponentFieldLinkPart(component, this.doInvisible);
        this.fields.add(fd);
    }

    private void valueChanged() {
        boolean previousState = this.currentState;
        this.currentState = this.isActif();
        boolean changeState = previousState ^ this.currentState;
        for (FieldLinkPart<?> fd : this.fields) {
            fd.enableField(this.currentState);
            if (!changeState) continue;
            if (!this.currentState) {
                fd.setDefaultValueOnDesactivate();
            } else {
                fd.setDefaultValueOnActivate();
            }
            if (fd.getFieldLink() == null) continue;
            fd.getFieldLink().valueChanged();
        }
    }

    public List<Enum<?>> getActives() {
        return this.actives;
    }

    public ComboBox getBox() {
        return this.box;
    }

    public String getComboTitle() {
        return this.validatorManager.getTitle((AbstractField)this.box);
    }
}

