/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.validator;

import com.vaadin.ui.AbstractField;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ValidatorHolder;
import java.util.regex.Pattern;

public class EmailValidator
implements IValidator {
    private static final String EMAIL_REGEXP = "^([a-zA-Z0-9_\\.\\-+'])+@(([a-zA-Z0-9-])+\\.)+([a-zA-Z0-9]{2,4})+$";
    private boolean explainDiese;

    public EmailValidator(boolean explainDiese) {
        this.explainDiese = explainDiese;
    }

    public EmailValidator() {
        this(true);
    }

    @Override
    public void performValidate(Object value, ValidatorHolder a) {
        String val = (String)value;
        if (!EmailValidator.isValidEmail(val)) {
            String str = "Le champ \"" + a.title + "\" n'est pas une adresse e mail valide.";
            if (this.explainDiese) {
                str = String.valueOf(str) + "Si la personne n'a pas d'email, merci de mettre son nom ou pr\u00e9nom suivi d'un #. Exemple : geraldine#";
            }
            a.addMessage(str);
        }
    }

    @Override
    public boolean canCheckOnFly() {
        return true;
    }

    public static boolean isValidEmail(String val) {
        if (val == null || val.length() <= 1) {
            return false;
        }
        if (val.endsWith("#")) {
            return true;
        }
        return Pattern.matches(EMAIL_REGEXP, val);
    }

    @Override
    public AbstractField[] revalidateOnChangeOf() {
        return null;
    }
}

