/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.validator;

import com.vaadin.ui.AbstractField;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ValidatorHolder;

public class IntegerRangeValidator
implements IValidator {
    private Integer valMin = null;
    private Integer valMax = null;

    public IntegerRangeValidator(Integer valMin, Integer valMax) {
        this.valMin = valMin;
        this.valMax = valMax;
    }

    @Override
    public void performValidate(Object value, ValidatorHolder a) {
        int val;
        if (value == null) {
            a.addMessage("La valeur doit \u00eatre renseign\u00e9e");
            return;
        }
        try {
            val = new Integer((String)value);
        }
        catch (NumberFormatException numberFormatException) {
            a.addMessage("Pour le champ \"" + a.title + "\" , impossible de d\u00e9coder " + value);
            return;
        }
        if (this.valMin != null && val < this.valMin) {
            a.addMessage("La valeur \"" + a.title + "\" est trop petite. Elle doit \u00eatre sup\u00e9rieur ou \u00e9gale \u00e0 " + this.valMin);
        }
        if (this.valMax != null && val > this.valMax) {
            a.addMessage("La valeur \"" + a.title + "\" est trop grande. Elle doit \u00eatre inf\u00e9rieur ou \u00e9gale \u00e0 " + this.valMax);
        }
    }

    @Override
    public boolean canCheckOnFly() {
        return true;
    }

    @Override
    public AbstractField[] revalidateOnChangeOf() {
        return null;
    }
}

