/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.formpopup.validator;

import com.vaadin.data.Property;
import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractField;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ValidatorHolder {
    protected AbstractField f;
    protected String title;
    protected Object propertyId;
    protected List<String> errorMessage = new ArrayList<String>();
    private IValidator validator;

    public ValidatorHolder(IValidator validator, AbstractField f, String title, Object propertyId) {
        this.validator = validator;
        this.f = f;
        this.title = title;
        this.propertyId = propertyId;
    }

    public void addMessage(String msg) {
        this.errorMessage.add(msg);
    }

    public List<String> validate() {
        this.errorMessage = new ArrayList<String>();
        Object value = this.f.getValue();
        this.validator.performValidate(value, this);
        if (this.errorMessage.size() > 0) {
            String str = this.computeHtml();
            this.f.setComponentError((ErrorMessage)new UserError(str, AbstractErrorMessage.ContentMode.HTML, ErrorMessage.ErrorLevel.ERROR));
            if (this.validator.canCheckOnFly()) {
                this.f.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleValueChange());
                AbstractField[] fields = this.validator.revalidateOnChangeOf();
                if (fields != null) {
                    AbstractField[] abstractFieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractField field = abstractFieldArray[n2];
                        field.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleValueChange());
                        ++n2;
                    }
                }
            }
        }
        return this.errorMessage;
    }

    private void handleValueChange() {
        this.errorMessage = new ArrayList<String>();
        Object value = this.f.getValue();
        this.validator.performValidate(value, this);
        if (this.errorMessage.size() == 0) {
            this.f.setComponentError(null);
        } else {
            String str = this.computeHtml();
            this.f.setComponentError((ErrorMessage)new UserError(str, AbstractErrorMessage.ContentMode.HTML, ErrorMessage.ErrorLevel.ERROR));
        }
    }

    private String computeHtml() {
        StringBuffer buf = new StringBuffer();
        for (String msg : this.errorMessage) {
            buf.append("<big>");
            buf.append(msg);
            buf.append("</big>");
            buf.append("<br/>");
        }
        return buf.toString();
    }

    public AbstractField getField() {
        return this.f;
    }

    public String getTitle() {
        return this.title;
    }
}

