/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.popup.suppressionpopup;

import com.vaadin.event.FieldEvents;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.popup.suppressionpopup.UnableToSuppressException;
import java.io.Serializable;
import java.util.function.Consumer;

public class SuppressionPopup
extends CorePopup {
    private Button okButton;
    private String okButtonTitle = "Supprimer";
    private String cancelButtonTitle = "Annuler";
    private boolean secured;
    private String message;
    private Long idItemToSuppress;
    private Consumer<Long> deleteAction;

    public SuppressionPopup(String message, Long idItemToSuppress, Consumer<Long> deleteAction) {
        this(message, idItemToSuppress, false, deleteAction);
    }

    public SuppressionPopup(String message, Long idItemToSuppress, boolean secured, Consumer<Long> deleteAction) {
        this.message = message;
        this.idItemToSuppress = idItemToSuppress;
        this.secured = secured;
        this.deleteAction = deleteAction;
        this.popupTitle = "Confirmation suppression";
    }

    @Override
    protected void createContent(VerticalLayout contentLayout) {
        this.setWidth(40, 450);
        HorizontalLayout hlTexte = new HorizontalLayout();
        hlTexte.setMargin(true);
        hlTexte.setSpacing(true);
        hlTexte.setWidth("100%");
        Label textArea = new Label(this.message);
        textArea.setStyleName("big");
        textArea.setWidth("80%");
        hlTexte.addComponent((Component)textArea);
        hlTexte.setExpandRatio((Component)textArea, 1.0f);
        hlTexte.setComponentAlignment((Component)textArea, Alignment.MIDDLE_CENTER);
        contentLayout.addComponent((Component)hlTexte);
        if (this.secured) {
            hlTexte = new HorizontalLayout();
            hlTexte.setMargin(true);
            hlTexte.setSpacing(true);
            hlTexte.setWidth("100%");
            textArea = new Label("Veuillez confirmer en saississant le mot SUPPRIMER dans le champ de saisie ci dessous");
            textArea.setStyleName("big");
            textArea.setWidth("80%");
            hlTexte.addComponent((Component)textArea);
            hlTexte.setExpandRatio((Component)textArea, 1.0f);
            hlTexte.setComponentAlignment((Component)textArea, Alignment.MIDDLE_CENTER);
            contentLayout.addComponent((Component)hlTexte);
            hlTexte = new HorizontalLayout();
            hlTexte.setMargin(true);
            hlTexte.setSpacing(true);
            hlTexte.setWidth("100%");
            TextField textField = new TextField();
            textField.setStyleName("big");
            textField.setWidth("80%");
            textField.setImmediate(true);
            textField.setBuffered(false);
            hlTexte.addComponent((Component)textField);
            hlTexte.setExpandRatio((Component)textField, 1.0f);
            hlTexte.setComponentAlignment((Component)textField, Alignment.MIDDLE_CENTER);
            textField.addTextChangeListener(new FieldEvents.TextChangeListener(){

                public void textChange(FieldEvents.TextChangeEvent event) {
                    if (event.getText().equals("SUPPRIMER")) {
                        SuppressionPopup.this.okButton.setEnabled(true);
                    } else {
                        SuppressionPopup.this.okButton.setEnabled(false);
                    }
                }
            });
            contentLayout.addComponent((Component)hlTexte);
        }
    }

    @Override
    protected void createButtonBar() {
        this.addButtonBlank();
        this.okButton = this.addButton(this.okButtonTitle, (Button.ClickListener & Serializable)e -> this.handleSupprimer());
        if (this.secured) {
            this.okButton.setEnabled(false);
            this.okButton.setImmediate(true);
        }
        this.addDefaultButton(this.cancelButtonTitle, (Button.ClickListener & Serializable)e -> this.handleAnnuler());
    }

    protected void handleAnnuler() {
        this.close();
    }

    protected void handleSupprimer() {
        try {
            this.deleteAction.accept(this.idItemToSuppress);
            Notification.show((String)"Suppression", (String)"Suppression faite", (Notification.Type)Notification.Type.HUMANIZED_MESSAGE);
        }
        catch (UnableToSuppressException e) {
            String title = "Erreur \u00e0 la suppression";
            String t1 = "Impossible de supprimer cet \u00e9l\u00e9ment. Raison :";
            String t2 = e.getMessage();
            MessagePopup popup = new MessagePopup(title, ContentMode.HTML, CorePopup.ColorStyle.RED, t1, t2);
            CorePopup.open(popup);
        }
        catch (Exception e) {
            ErrorPopup.open("Impossible de supprimer cet element.", e);
        }
        this.close();
    }
}

