/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.searcher;

import com.vaadin.data.Property;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Field;
import fr.amapj.model.engine.Identifiable;
import fr.amapj.view.engine.searcher.SearcherDefinition;
import java.util.List;

public class Searcher
extends ComboBox {
    private Object params;
    private SearcherDefinition iSearcher;
    private Searcher linkedSearcher;
    private List<? extends Identifiable> fixedValues = null;

    public Searcher(SearcherDefinition iSearcher) {
        this(iSearcher, iSearcher.getTitle(), null);
    }

    public Searcher(SearcherDefinition iSearcher, String title) {
        this(iSearcher, title, null);
    }

    public Searcher(SearcherDefinition iSearcher, String title, List<? extends Identifiable> fixedValues) {
        super(title);
        this.iSearcher = iSearcher;
        this.fixedValues = fixedValues;
        this.setImmediate(true);
        this.setWidth("300px");
        this.refreshLines();
    }

    public void setLinkedSearcher(Searcher linkedSearcher) {
        this.linkedSearcher = linkedSearcher;
        linkedSearcher.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                Searcher.this.handleChangeLinkedSearcher();
            }
        });
        if (linkedSearcher.getConvertedValue() != null) {
            this.handleChangeLinkedSearcher();
        }
    }

    private void handleChangeLinkedSearcher() {
        this.refreshLines();
    }

    private void refreshLines() {
        this.removeAllItems();
        List<? extends Identifiable> identifiables = this.getValues();
        for (Identifiable identifiable : identifiables) {
            this.addItem(identifiable.getId());
            this.setItemCaption(identifiable.getId(), this.iSearcher.toString(identifiable));
        }
    }

    private List<? extends Identifiable> getValues() {
        if (this.fixedValues != null) {
            return this.fixedValues;
        }
        return this.iSearcher.getAllElements(this.params);
    }

    public void bind(FieldGroup binder, String propertyId) {
        binder.bind((Field)this, (Object)propertyId);
    }
}

