/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.statuspage;

import com.vaadin.ui.Upload;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.BoundedByteArrayOutputStream;
import fr.amapj.common.FormatUtils;
import fr.amapj.service.services.advanced.maintenance.MaintenanceService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class StatusPageBackupImporter
implements Upload.Receiver {
    public BoundedByteArrayOutputStream baos;
    private String filename;

    public OutputStream receiveUpload(String filename, String mimeType) {
        this.filename = filename;
        this.baos = new BoundedByteArrayOutputStream(5000000, 50000000);
        return this.baos;
    }

    public Result getResult() {
        try {
            return this.performResult();
        }
        catch (Exception e) {
            Result r = new Result();
            r.errorMessage = e.getMessage();
            return r;
        }
    }

    private Result performResult() throws ParseException, IOException {
        Result r = new Result();
        if (this.filename.length() <= 32) {
            throw new RuntimeException("Nom de fichier incorrect : le nom du fichier doit avoir une longueur sup\u00e9rieure \u00e0 32");
        }
        if (!this.filename.endsWith(".tar.gz")) {
            throw new RuntimeException("Nom de fichier incorrect : le nom du fichier doit se terminer par .tar.gz");
        }
        String dbName = this.filename.substring(0, this.filename.length() - 32);
        String extension = this.filename.substring(this.filename.length() - 32, this.filename.length() - 7);
        r.version = extension.substring(1, 5);
        r.isVersionOK = this.isVersionOK(r.version);
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        Date ref = df.parse(extension.substring(6, 25));
        r.content = "<ul><li>Type de la base de donn\u00e9es : SAUVEGARDE d'une base de donn\u00e9es de production</li><li>Nom de la base : " + dbName + "</li>" + "<li>Date de la sauvegarde : " + FormatUtils.getTimeStd().format(ref) + "</li>" + "<li>Version AMAPJ \u00e0 la date de sauvegarde : " + r.version + "</li>" + "<li>Login \u00e0 utiliser : les m\u00eames qu'auparavant</li>" + "<li>Mot de passe \u00e0 utiliser : a</li>" + "<li>(Tous les mots de passe ont \u00e9t\u00e9 remplac\u00e9s par a)</li>" + "</ul>";
        GZIPInputStream zipIn = new GZIPInputStream(this.baos.getInputStream());
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)zipIn);
        r.fileProperties = this.processEntry(tarIn, dbName, "properties");
        r.fileScript = this.processEntry(tarIn, dbName, "script");
        tarIn.close();
        return r;
    }

    private boolean isVersionOK(String version) {
        String currentVersion = new MaintenanceService().getShortVersion();
        return currentVersion.equals(version);
    }

    private byte[] processEntry(TarArchiveInputStream tarIn, String dbName, String suffix) throws IOException {
        ArchiveEntry entry = tarIn.getNextEntry();
        if (entry.isDirectory()) {
            throw new AmapjRuntimeException();
        }
        int bufferSize = 131072;
        byte[] data = new byte[bufferSize];
        if (!entry.getName().equals(String.valueOf(dbName) + "." + suffix)) {
            throw new AmapjRuntimeException("entryName = " + entry.getName());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var10_10 = null;
        try (BufferedOutputStream dest = new BufferedOutputStream(baos, bufferSize);){
            int count;
            while ((count = tarIn.read(data, 0, bufferSize)) != -1) {
                dest.write(data, 0, count);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return baos.toByteArray();
    }

    public static class Result {
        public String errorMessage;
        public String warningVersionMessage;
        public String version;
        public boolean isVersionOK;
        public String content;
        public byte[] fileProperties;
        public byte[] fileScript;
    }
}

