/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.tools;

import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.validator.DateRangeValidator;
import com.vaadin.server.Page;
import com.vaadin.server.WebBrowser;
import com.vaadin.shared.ui.datefield.Resolution;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.engine.widgets.DoubleTextFieldConverter;
import fr.amapj.view.engine.widgets.IntegerTextFieldConverter;
import fr.amapj.view.engine.widgets.QteTextFieldConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class BaseUiTools {
    public static Label addStdLabel(Layout layout, String content, String styleName) {
        Label tf = new Label(content);
        tf.addStyleName(styleName);
        layout.addComponent((Component)tf);
        return tf;
    }

    public static Label addHtmlLabel(Layout layout, String content, String styleName) {
        Label tf = new Label(content, ContentMode.HTML);
        tf.addStyleName(styleName);
        layout.addComponent((Component)tf);
        return tf;
    }

    public static VerticalLayout addPanel(Layout layout, String styleName) {
        Panel p0 = new Panel();
        p0.setWidth("100%");
        p0.addStyleName(styleName);
        VerticalLayout vl1 = new VerticalLayout();
        vl1.setMargin(true);
        p0.setContent((Component)vl1);
        layout.addComponent((Component)p0);
        return vl1;
    }

    public static Label addBandeau(Layout layout, String content, String styleName) {
        Label l = new Label(content, ContentMode.HTML);
        l.setWidth("100%");
        Panel p1 = new Panel();
        p1.setContent((Component)l);
        p1.addStyleName("bandeau-" + styleName);
        layout.addComponent((Component)p1);
        return l;
    }

    public static HorizontalLayout addBandeau(Layout layout, String textLeft, String textRight, String styleName) {
        HorizontalLayout hl = new HorizontalLayout();
        hl.setWidth("100%");
        Label l1 = new Label(textLeft, ContentMode.HTML);
        l1.setWidthUndefined();
        hl.addComponent((Component)l1);
        hl.setComponentAlignment((Component)l1, Alignment.MIDDLE_LEFT);
        Label l2 = new Label(textRight, ContentMode.HTML);
        l2.setWidthUndefined();
        hl.addComponent((Component)l2);
        hl.setComponentAlignment((Component)l2, Alignment.MIDDLE_RIGHT);
        Panel p1 = new Panel();
        p1.setContent((Component)hl);
        p1.addStyleName("bandeau-" + styleName);
        layout.addComponent((Component)p1);
        return hl;
    }

    public static Label addEmptyLine(Layout layout) {
        Label l = new Label("<br/>", ContentMode.HTML);
        layout.addComponent((Component)l);
        return l;
    }

    public static boolean isCompactMode() {
        Page page = UI.getCurrent().getPage();
        int width = page.getBrowserWindowWidth();
        int height = page.getBrowserWindowHeight();
        return height < 700 || width < 700;
    }

    public static boolean isWidthBelow(int width) {
        Page page = UI.getCurrent().getPage();
        int currentWidth = page.getBrowserWindowWidth();
        return currentWidth < width;
    }

    public static int getWidth() {
        Page page = UI.getCurrent().getPage();
        int currentWidth = page.getBrowserWindowWidth();
        return currentWidth;
    }

    public static int getHeight() {
        Page page = UI.getCurrent().getPage();
        return page.getBrowserWindowHeight();
    }

    public static int computePopupWidth(int widthRatio) {
        Page page = UI.getCurrent().getPage();
        int currentWidth = page.getBrowserWindowWidth();
        return currentWidth * widthRatio / 100;
    }

    public static PopupDateField createDateField(FieldGroup binder, String propertyId, String title) {
        PopupDateField sample = BaseUiTools.createPopupDateField(title);
        binder.bind((Field)sample, (Object)propertyId);
        return sample;
    }

    public static PopupDateField createDateField(String title) {
        PopupDateField sample = BaseUiTools.createPopupDateField(title);
        return sample;
    }

    private static PopupDateField createPopupDateField(String title) {
        PopupDateField sample = new PopupDateField(title){

            protected Date handleUnparsableDateString(String dateString) throws Converter.ConversionException {
                ArrayList<String> strs = new ArrayList<String>();
                strs.add("Nous ne comprenons pas la date \"" + dateString + "\"");
                strs.add("Merci de cliquer sur l'icone de calendrier sur la gauche pour choisir la date");
                strs.add("ou de saisir la date au format 02/10/21 pour le 2 octobre 2021");
                MessagePopup.open(new MessagePopup("Erreur sur la date", strs));
                return null;
            }
        };
        try {
            String errorMessage = "La date est incorrecte. Elle doit \u00eatre obligatoirement comprise entre 2000 et 2100";
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            Date minValue = df.parse("01/01/2000");
            Date maxValue = df.parse("01/01/2100");
            sample.addValidator((Validator)new DateRangeValidator(errorMessage, minValue, maxValue, null));
        }
        catch (ParseException e) {
            throw new AmapjRuntimeException(e);
        }
        sample.setValue((Object)DateUtils.getDate());
        sample.setImmediate(true);
        sample.setLocale(Locale.FRANCE);
        sample.setResolution(Resolution.DAY);
        return sample;
    }

    public static TextField createQteField(String title) {
        TextField tf = new TextField(title);
        tf.setConverter((Converter)new QteTextFieldConverter());
        tf.setNullRepresentation("");
        tf.setImmediate(true);
        return tf;
    }

    public static TextField createIntegerField(String title) {
        TextField tf = new TextField(title);
        tf.setConverter((Converter)new IntegerTextFieldConverter());
        tf.setNullRepresentation("");
        tf.setImmediate(true);
        return tf;
    }

    public static TextField createDoubleField(String title) {
        TextField tf = new TextField(title);
        tf.setConverter((Converter)new DoubleTextFieldConverter());
        tf.setNullRepresentation("");
        tf.setImmediate(true);
        return tf;
    }

    public static TextField createCurrencyField(String title, boolean allowNegativeNumber) {
        TextField tf = new TextField(title);
        tf.setConverter((Converter)new CurrencyTextFieldConverter(allowNegativeNumber));
        tf.setNullRepresentation("");
        tf.setImmediate(true);
        return tf;
    }

    public static CheckBox createCheckBoxField(String title) {
        CheckBox checkbox = new CheckBox();
        checkbox.addStyleName("align-center");
        checkbox.setImmediate(true);
        return checkbox;
    }

    public static Table createStaticTable(int nbCol) {
        Table t = new Table();
        t.setStyleName("big");
        t.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        int i = 0;
        while (i < nbCol) {
            t.addContainerProperty((Object)"", String.class, null);
            ++i;
        }
        return t;
    }

    public static Table addLine(Table t, String ... line) {
        t.addItem((Object[])line, null);
        return t;
    }

    public static void setReadOnlyRecursively(HasComponents a) {
        for (Component component : a) {
            component.setReadOnly(true);
            if (!(component instanceof HasComponents)) continue;
            BaseUiTools.setReadOnlyRecursively((HasComponents)component);
        }
    }

    public static boolean isFirefoxAndroid() {
        WebBrowser browser = UI.getCurrent().getPage().getWebBrowser();
        return browser.isFirefox() && browser.isAndroid();
    }
}

