/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.tools;

import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.ui.Table;
import fr.amapj.view.engine.tools.TableItem;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TableTools {
    public static boolean updateTable(Table cdesTable, List<? extends TableItem> res, String[] sortColumns, boolean[] sortAscending) {
        BeanItemContainer mcInfos = (BeanItemContainer)cdesTable.getContainerDataSource();
        TableItem current = (TableItem)cdesTable.getValue();
        mcInfos.removeAllItems();
        mcInfos.addAll(res);
        cdesTable.setValue(null);
        mcInfos.sort((Object[])sortColumns, sortAscending);
        if (current != null) {
            boolean done = false;
            for (TableItem tableItem : res) {
                if (!tableItem.getId().equals(current.getId())) continue;
                cdesTable.setValue((Object)tableItem);
                done = true;
            }
            return done;
        }
        return false;
    }

    public static boolean updateTableMultiselect(Table cdesTable, List<? extends TableItem> res, String[] sortColumns, boolean[] sortAscending) {
        BeanItemContainer mcInfos = (BeanItemContainer)cdesTable.getContainerDataSource();
        Set current = (Set)cdesTable.getValue();
        mcInfos.removeAllItems();
        mcInfos.addAll(res);
        mcInfos.sort((Object[])sortColumns, sortAscending);
        if (current.size() == 0) {
            return false;
        }
        TreeSet<TableItem> newSelection = new TreeSet<TableItem>();
        for (TableItem tableItem : res) {
            if (!TableTools.wasSelected(tableItem.getId(), current)) continue;
            newSelection.add(tableItem);
        }
        cdesTable.setValue(newSelection);
        return newSelection.size() > 0;
    }

    private static boolean wasSelected(Long id, Set<TableItem> current) {
        for (TableItem tableItem : current) {
            if (!tableItem.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

