/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.tools.table.complex;

import com.vaadin.data.Item;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Link;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.view.engine.enumselector.EnumSearcher;
import fr.amapj.view.engine.excelgenerator.LinkCreator;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.engine.searcher.SearcherDefinition;
import fr.amapj.view.engine.tools.table.TableColumnInfo;
import fr.amapj.view.engine.tools.table.TableColumnType;
import fr.amapj.view.engine.widgets.CurrencyTextFieldConverter;
import fr.amapj.view.engine.widgets.IntegerTextFieldConverter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ComplexTableBuilder<T> {
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
    private List<TableColumnInfo<T>> cols;
    private Table t;
    private List<T> beans;
    private int pageLength = 15;
    HorizontalLayout header1;
    String styleName;
    int height;

    public ComplexTableBuilder(List<T> beans) {
        this.beans = beans;
        this.cols = new ArrayList<TableColumnInfo<T>>();
    }

    public void addString(String title, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, null, editable, width, TableColumnType.STRING, toVal, null, null, null, null);
    }

    public void addString(String title, String property, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, property, editable, width, TableColumnType.STRING, toVal, null, null, null, null);
    }

    public void addInteger(String title, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, null, editable, width, TableColumnType.INTEGER, toVal, null, null, null, null);
    }

    public void addInteger(String title, String property, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, property, editable, width, TableColumnType.INTEGER, toVal, null, null, null, null);
    }

    public void addCurrency(String title, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, null, editable, width, TableColumnType.CURRENCY, toVal, null, null, null, null);
    }

    public void addCurrency(String title, String property, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, property, editable, width, TableColumnType.CURRENCY, toVal, null, null, null, null);
    }

    public void addDate(String title, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, null, editable, width, TableColumnType.DATE, toVal, null, null, null, null);
    }

    public void addDate(String title, String property, boolean editable, int width, ToValue<T> toVal) {
        this.addColumn(title, property, editable, width, TableColumnType.DATE, toVal, null, null, null, null);
    }

    public void addCheckBox(String title, boolean editable, int width, ToValue<T> toVal, CallBack<T> onClic) {
        this.addColumn(title, null, editable, width, TableColumnType.CHECK_BOX, toVal, onClic, null, null, null);
    }

    public void addCheckBox(String title, String property, boolean editable, int width, ToValue<T> toVal, CallBack<T> onClic) {
        this.addColumn(title, property, editable, width, TableColumnType.CHECK_BOX, toVal, onClic, null, null, null);
    }

    public void addButton(String title, int width, ToValue<T> toVal, CallBack<T> onClic) {
        this.addColumn(title, null, false, width, TableColumnType.BUTTON, toVal, onClic, null, null, null);
    }

    public void addButton(String title, String property, int width, ToValue<T> toVal, CallBack<T> onClic) {
        this.addColumn(title, property, false, width, TableColumnType.BUTTON, toVal, onClic, null, null, null);
    }

    public void addLink(String title, int width, ToValue<T> toVal, ToGenerator<T> generator) {
        this.addColumn(title, null, false, width, TableColumnType.LINK, toVal, null, generator, null, null);
    }

    public void addSearcher(String title, boolean editable, int width, ToValue<T> toVal, SearcherDefinition searcher) {
        this.addColumn(title, null, editable, width, TableColumnType.SEARCHER, toVal, null, null, searcher, null);
    }

    public void addSearcher(String title, String property, boolean editable, int width, ToValue<T> toVal, SearcherDefinition searcher) {
        this.addColumn(title, property, editable, width, TableColumnType.SEARCHER, toVal, null, null, searcher, null);
    }

    public void addCombo(String title, boolean editable, int width, ToValue<T> toVal, Class<Enum> enumClazz) {
        this.addColumn(title, null, editable, width, TableColumnType.COMBO, toVal, null, null, null, enumClazz);
    }

    public void addCombo(String title, String property, boolean editable, int width, ToValue<T> toVal, Class<? extends Enum> enumClazz) {
        this.addColumn(title, property, editable, width, TableColumnType.COMBO, toVal, null, null, null, enumClazz);
    }

    private void addColumn(String title, String property, boolean editable, int width, TableColumnType type, ToValue<T> toVal, CallBack<T> onClic, ToGenerator<T> generator, SearcherDefinition searcher, Class<? extends Enum> enumClazz) {
        this.cols.add(new TableColumnInfo<T>(title, property, editable, width, type, toVal, onClic, generator, searcher, enumClazz));
    }

    public void buildComponent(Layout contentLayout) {
        this.startHeader("tete", 70);
        for (TableColumnInfo<T> col : this.cols) {
            this.addHeaderBox(col.title, col.width + 13, col);
        }
        contentLayout.addComponent((Component)this.header1);
        this.t = new Table();
        int index = 0;
        for (TableColumnInfo<T> col : this.cols) {
            String property = col.property;
            if (property == null) {
                property = "property" + index;
            }
            this.t.addContainerProperty((Object)property, this.getClass(col.type, col.editable), null);
            ++index;
        }
        index = 0;
        for (Object bean : this.beans) {
            Object[] cells = this.computeCell(bean);
            this.t.addItem(cells, (Object)index);
            ++index;
        }
        this.t.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.t.setSelectable(true);
        this.t.setSortEnabled(false);
        this.t.setPageLength(this.pageLength);
        contentLayout.addComponent((Component)this.t);
    }

    private Class<?> getClass(TableColumnType type, boolean editable) {
        switch (type) {
            case STRING: 
            case CURRENCY: 
            case INTEGER: 
            case DATE: {
                if (editable) {
                    return TextField.class;
                }
                return Label.class;
            }
            case CHECK_BOX: {
                return CheckBox.class;
            }
            case BUTTON: {
                return Button.class;
            }
            case LINK: {
                return Link.class;
            }
            case SEARCHER: {
                return ComboBox.class;
            }
            case COMBO: {
                return ComboBox.class;
            }
        }
        throw new AmapjRuntimeException();
    }

    private Object[] computeCell(T bean) {
        Object[] cells = new Object[this.cols.size()];
        int index = 0;
        for (TableColumnInfo<T> col : this.cols) {
            cells[index] = this.createPart(col, bean);
            ++index;
        }
        return cells;
    }

    private Object createPart(TableColumnInfo<T> col, T bean) {
        switch (col.type) {
            case STRING: {
                Object o = col.toVal.toValue(bean);
                if (o == null) {
                    o = "";
                }
                if (col.editable) {
                    return this.createTextField(o.toString(), col.width);
                }
                return this.createLabel(o.toString(), col.width);
            }
            case DATE: {
                Object o = col.toVal.toValue(bean);
                if (o == null) {
                    return this.createLabel("", col.width);
                }
                return this.createLabel(this.df.format((Date)o), col.width);
            }
            case INTEGER: {
                Integer cVal = (Integer)col.toVal.toValue(bean);
                if (col.editable) {
                    return this.createIntegerEditableField(cVal, col.width);
                }
                return this.createLabel(Integer.toString(cVal), col.width);
            }
            case CURRENCY: {
                Integer currentVal = (Integer)col.toVal.toValue(bean);
                if (col.editable) {
                    return this.createCurrencyEditableField(currentVal, col.width);
                }
                return this.createLabel(new CurrencyTextFieldConverter().convertToString(currentVal), col.width);
            }
            case CHECK_BOX: {
                return this.createCheckBox((Boolean)col.toVal.toValue(bean), col.width);
            }
            case BUTTON: {
                String str = (String)col.toVal.toValue(bean);
                if (str != null) {
                    return this.createButton(str, col.width, col.onClic, bean);
                }
                return null;
            }
            case LINK: {
                return this.createLink(col.toVal.toValue(bean).toString(), col.width, col.generator, bean);
            }
            case SEARCHER: {
                return this.createSearcher((Long)col.toVal.toValue(bean), col.searcher, col.editable, col.width, bean);
            }
            case COMBO: {
                return this.createCombo((Enum)col.toVal.toValue(bean), col.editable, col.width, col.enumClazz);
            }
        }
        throw new AmapjRuntimeException();
    }

    private ComboBox createCombo(Enum value, boolean editable, int width, Class<? extends Enum> enumClazz) {
        ComboBox box = EnumSearcher.createEnumSearcher("", enumClazz);
        box.setValue((Object)value);
        box.setEnabled(editable);
        box.setWidth(String.valueOf(width) + "px");
        return box;
    }

    private ComboBox createSearcher(Long value, SearcherDefinition searcher, boolean editable, int width, T bean) {
        Searcher box = new Searcher(searcher, null);
        box.setConvertedValue(value);
        return box;
    }

    private TextField createIntegerEditableField(Integer currentVal, int taille) {
        TextField tf = new TextField();
        tf.addStyleName("align-center");
        tf.setConverter((Converter)new IntegerTextFieldConverter());
        tf.setConvertedValue((Object)currentVal);
        tf.setNullRepresentation("");
        tf.setWidth(String.valueOf(taille) + "px");
        tf.setImmediate(true);
        return tf;
    }

    private TextField createCurrencyEditableField(Integer currentVal, int taille) {
        TextField tf = new TextField();
        tf.addStyleName("align-center");
        tf.setConverter((Converter)new CurrencyTextFieldConverter(true));
        tf.setConvertedValue((Object)currentVal);
        tf.setNullRepresentation("");
        tf.setWidth(String.valueOf(taille) + "px");
        tf.setImmediate(true);
        return tf;
    }

    private Label createLabel(String msg, int taille) {
        Label l = new Label(msg);
        l.addStyleName("align-center");
        l.setWidth(String.valueOf(taille) + "px");
        return l;
    }

    private CheckBox createCheckBox(boolean value, int taille) {
        CheckBox cb = new CheckBox();
        cb.addStyleName("align-center");
        cb.setValue((Object)value);
        cb.setWidth(String.valueOf(taille) + "px");
        cb.setImmediate(true);
        return cb;
    }

    private Button createButton(String msg, int taille, CallBack<T> onClic, T t) {
        Button cb = new Button(msg);
        cb.addStyleName("align-center");
        cb.setWidth(String.valueOf(taille) + "px");
        cb.setImmediate(true);
        cb.addClickListener((Button.ClickListener & Serializable)e -> onClic.onClick(t));
        return cb;
    }

    private Link createLink(String msg, int taille, ToGenerator<T> generator, T t) {
        Link l = LinkCreator.createLink(generator.getGenerator(t));
        l.setCaption(msg);
        l.addStyleName("align-center");
        l.setWidth(String.valueOf(taille) + "px");
        l.setImmediate(true);
        return l;
    }

    private TextField createTextField(String value, int taille) {
        TextField tf = new TextField();
        tf.setValue(value);
        tf.setWidth(String.valueOf(taille) + "px");
        tf.setNullRepresentation("");
        tf.setImmediate(true);
        return tf;
    }

    private void startHeader(String styleName, int height) {
        this.header1 = new HorizontalLayout();
        this.header1.setHeight(null);
        this.header1.setWidth(null);
        this.styleName = styleName;
        this.height = height;
    }

    private void addHeaderBox(String msg, int taille, TableColumnInfo<T> col) {
        int additionnalWith = this.computeAdditionnalWidth(col);
        Label hLabel = new Label(msg);
        hLabel.setWidth(String.valueOf(taille + additionnalWith) + "px");
        hLabel.setHeight(String.valueOf(this.height) + "px");
        hLabel.addStyleName(this.styleName);
        this.header1.addComponent((Component)hLabel);
    }

    private int computeAdditionnalWidth(TableColumnInfo<T> col) {
        switch (col.type) {
            case STRING: {
                if (col.editable) {
                    return -1;
                }
                return 11;
            }
        }
        return 13;
    }

    public AbstractField getComponent(int lineNumber, String property) {
        Item item = this.t.getItem((Object)lineNumber);
        AbstractField tf = (AbstractField)item.getItemProperty((Object)property).getValue();
        return tf;
    }

    public Button getButton(int lineNumber, String property) {
        Item item = this.t.getItem((Object)lineNumber);
        Button tf = (Button)item.getItemProperty((Object)property).getValue();
        return tf;
    }

    public Button getButton(T t, String property) {
        int lineNumber = this.beans.indexOf(t);
        return this.getButton(lineNumber, property);
    }

    public Label getLabel(int lineNumber, String property) {
        Item item = this.t.getItem((Object)lineNumber);
        Label tf = (Label)item.getItemProperty((Object)property).getValue();
        return tf;
    }

    public Label getLabel(T t, String property) {
        int lineNumber = this.beans.indexOf(t);
        return this.getLabel(lineNumber, property);
    }

    public void reload(List<T> beans) {
        this.beans = beans;
        this.t.removeAllItems();
        int index = 0;
        for (T bean : beans) {
            Object[] cells = this.computeCell(bean);
            this.t.addItem(cells, (Object)index);
            ++index;
        }
    }

    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
    }

    public T getSelectedLine() {
        Integer index = (Integer)this.t.getValue();
        if (index == null) {
            return null;
        }
        T dto = this.beans.get(index);
        return dto;
    }

    public void addStyleName(String styleName) {
        this.t.addStyleName(styleName);
    }

    public int getTotalWidth() {
        int width = 0;
        for (TableColumnInfo<T> col : this.cols) {
            width = width + col.width + this.computeAdditionnalWidth(col) + 13;
        }
        return width;
    }

    public List<T> getSelectedCheckBox(String property) {
        ArrayList<T> res = new ArrayList<T>();
        int i = 0;
        while (i < this.beans.size()) {
            T mc = this.beans.get(i);
            CheckBox cb = (CheckBox)this.getComponent(i, property);
            if (((Boolean)cb.getValue()).booleanValue()) {
                res.add(mc);
            }
            ++i;
        }
        return res;
    }

    public static interface CallBack<T> {
        public void onClick(T var1);
    }

    public static interface ToGenerator<T> {
        public CoreGenerator getGenerator(T var1);
    }

    public static interface ToValue<T> {
        public Object toValue(T var1);
    }
}

