/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.ui;

import com.vaadin.ui.UI;
import fr.amapj.model.models.saas.TypLog;
import fr.amapj.service.services.session.SessionData;
import fr.amapj.service.services.session.SessionParameters;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class AmapJLogManager {
    public static final String LOG4J_ID = "fileId";
    public static final String LOG4J_LOGDIR_ID = "amapjLogDir";
    public static final String FILE_USER = "user__";
    public static final String FILE_DEAMON = "deamon__";
    public static final String DATE_FORMAT = "yyyy_MM_dd__HH_mm_ss";
    private static final Logger logger = LogManager.getLogger();
    private static String logDir;

    public static String createLogFileName(String dbName, Long idLogAccess, Date dateIn, TypLog typLog) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        String logFileName = String.valueOf(dbName) + "/" + (typLog == TypLog.USER ? FILE_USER : FILE_DEAMON) + dbName + "__" + df.format(dateIn) + "__" + idLogAccess;
        ThreadContext.put((String)LOG4J_ID, (String)logFileName);
        return logFileName;
    }

    public static void initializeLogUI(UI ui) {
        SessionParameters sessionParameters;
        if (ui != null && ui.getData() != null && (sessionParameters = ((SessionData)ui.getData()).sessionParameters) != null) {
            ThreadContext.put((String)LOG4J_ID, (String)sessionParameters.logFileName);
            return;
        }
        ThreadContext.put((String)LOG4J_ID, null);
    }

    public static void endLog(boolean definitive, String fileNameToClose) {
        if (definitive) {
            AmapJLogManager.stopLogger(fileNameToClose);
        }
        ThreadContext.put((String)LOG4J_ID, null);
    }

    private static void stopLogger(String fileNameToClose) {
        if (fileNameToClose == null) {
            logger.error("FUITE-FICHIER : impossible de fermer le fichier null");
            return;
        }
        org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
        LoggerContext context = coreLogger.getContext();
        RoutingAppender appender = (RoutingAppender)context.getConfiguration().getAppender("Routing");
        appender.deleteAppender(fileNameToClose);
    }

    public static void setLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    public static Level getLevel() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        return loggerConfig.getLevel();
    }

    public static String getFullFileName(String logFileName) {
        return String.valueOf(logDir) + "/" + logFileName + ".log";
    }

    public static void setLogDir(String logDir) {
        AmapJLogManager.logDir = logDir;
        System.setProperty(LOG4J_LOGDIR_ID, logDir);
    }
}

