/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.ui;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.server.DefaultErrorHandler;
import com.vaadin.server.ErrorEvent;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.Responsive;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.service.services.appinstance.AppState;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.menu.MenuPart;
import fr.amapj.view.engine.popup.errorpopup.ErrorPopup;
import fr.amapj.view.engine.statuspage.StatusPageView;
import fr.amapj.view.engine.ui.AppConfiguration;
import fr.amapj.view.engine.ui.ValoMenuLayout;
import fr.amapj.view.views.login.LoginPart;
import fr.amapj.view.views.login.passwordrecovery.PopupSaisieNewPasswordForPasswordRecovery;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Theme(value="amapj")
@Title(value="AMAP")
public class AmapUI
extends UI {
    private MenuPart menuPart = new MenuPart();
    private LoginPart loginPart = new LoginPart();
    private static final Logger logger = LogManager.getLogger();
    private ValoMenuLayout root = new ValoMenuLayout();

    protected void init(VaadinRequest request) {
        logger.info("Demarrage d'une nouvelle session:" + this.getSession().getCsrfToken());
        SessionManager.register(this);
        this.setErrorHandling();
        this.setLocale(Locale.FRANCE);
        if (this.isStatusPageMode(request)) {
            new StatusPageView(this).open();
            return;
        }
        String dbName = this.getDbName(request);
        DataBaseInfo dataBaseInfo = DbManager.get().findDataBaseFromName(dbName);
        if (dataBaseInfo == null) {
            this.getPage().setLocation("https://amapj.fr/listeamaps.html");
            return;
        }
        if (dataBaseInfo.getState() != AppState.ON) {
            String contextPath = AppConfiguration.getConf().getContextPath();
            this.getPage().setLocation(String.valueOf(contextPath) + "/infoservlet/maintenance");
            return;
        }
        SessionManager.initSessionData(dataBaseInfo);
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String sudo = request.getParameter("sudo");
        String resetPasswordSalt = request.getParameter("resetPassword");
        if (resetPasswordSalt != null) {
            new PopupSaisieNewPasswordForPasswordRecovery(resetPasswordSalt).open();
        }
        Responsive.makeResponsive((Component[])new Component[]{this});
        this.setContent((Component)this.root);
        this.root.setSizeFull();
        this.addStyleName("valo-menu-responsive");
        this.buildLoginView(username, password, sudo);
    }

    private boolean isStatusPageMode(VaadinRequest request) {
        if (!AppConfiguration.getConf().isStatusPageAllowed()) {
            return false;
        }
        String path = request.getPathInfo();
        return path.startsWith("/status/page");
    }

    private void setErrorHandling() {
        this.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(ErrorEvent event) {
                Throwable t = event.getThrowable();
                try {
                    ErrorPopup.open(t);
                }
                catch (Exception exception) {
                    logger.error(StackUtils.asString(t));
                }
            }
        });
    }

    public String getDbName(VaadinRequest request) {
        String dbName = request.getPathInfo();
        if (dbName == null || dbName.length() <= 1) {
            dbName = "amap1";
        } else if ((dbName = dbName.substring(1)).indexOf(47) > 0) {
            dbName = dbName.substring(0, dbName.indexOf(47));
        }
        return dbName;
    }

    public void detach() {
        if (SessionManager.canDisconnect()) {
            new PasswordManager().disconnect();
        }
        SessionManager.unregister(this);
        super.detach();
    }

    public void receiveBroadcast(final String message) {
        this.access(new Runnable(){

            @Override
            public void run() {
                Notification n = new Notification("Message recu", message, Notification.Type.WARNING_MESSAGE);
                n.show(AmapUI.this.getPage());
            }
        });
    }

    public void buildLoginView(String username, String password, String sudo) {
        this.loginPart.buildLoginView(this.root, this, username, password, sudo);
    }

    public void buildMainView() {
        this.menuPart.buildMainView(this, this.root);
    }

    protected void refresh(VaadinRequest request) {
        String dbName = this.getDbName(request);
        if (this.getData() != null && SessionManager.getDb() != null && !SessionManager.getDb().getDbName().equals(dbName)) {
            this.getPage().reload();
            this.close();
            return;
        }
    }

    public ValoMenuLayout getRoot() {
        return this.root;
    }
}

