/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.engine.ui;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DevPath;
import fr.amapj.model.engine.dbms.DBMSConf;
import fr.amapj.model.engine.dbms.hsqlexternal.HsqlExternalDbmsConf;
import fr.amapj.model.engine.dbms.hsqlinternal.HsqlInternalDbmsConf;
import fr.amapj.service.engine.appinitializer.MockServletParameter;
import fr.amapj.service.engine.appinitializer.ServletParameter;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;

public class AppConfiguration {
    private static AppConfiguration mainInstance;
    private String backupDirectory;
    private String backupCommand;
    private String maintenanceKey;
    private boolean pdfConversionWithMessagingCenter;
    private String wkhtmltopdfCommand = null;
    private boolean adminFull = true;
    private String contextPath;
    private boolean allowTimeControl = false;
    private boolean statusPageAllowed = false;
    private MailConfig mailConfig;
    private String overrideSudoBaseUrl = null;
    private String messagingCenterUrl = null;
    private String messagingCenterKey = null;
    private String s3StorageEndPoint = null;
    private String s3StorageLogin = null;
    private String s3StoragePassword = null;
    private String s3StorageBucket = null;
    private String s3StorageKeyPrefix = null;
    private String localCacheDir;
    private String localCacheSize;
    private DBMSConf dbmsConf;
    private AppInstanceDTO masterConf;

    public static AppConfiguration getConf() {
        if (mainInstance == null) {
            throw new RuntimeException("Vous devez d'abord charger les parametres avec la methode load");
        }
        return mainInstance;
    }

    public static void load(ServletParameter param) {
        if (mainInstance != null) {
            throw new RuntimeException("Impossible de charger deux fois les parametres");
        }
        mainInstance = new AppConfiguration();
        mainInstance.loadInternal(param);
    }

    private AppConfiguration() {
    }

    private void loadInternal(ServletParameter param) {
        this.contextPath = param.getContextPath();
        this.backupDirectory = param.read("database.backupdir");
        this.backupCommand = param.read("database.backupCmd");
        this.maintenanceKey = param.read("maintenanceKey");
        this.pdfConversionWithMessagingCenter = param.read("pdfConversionWithMessagingCenter", "FALSE").equalsIgnoreCase("TRUE");
        this.wkhtmltopdfCommand = param.read("wkhtmltopdf");
        String logDir = param.read("logDir");
        AmapJLogManager.setLogDir(logDir);
        this.adminFull = param.read("adminFull", "TRUE").equalsIgnoreCase("TRUE");
        this.allowTimeControl = param.read("allowTimeControl", "FALSE").equalsIgnoreCase("TRUE");
        this.statusPageAllowed = param.read("statusPageAllowed", "FALSE").equalsIgnoreCase("TRUE");
        this.mailConfig = this.readMailConfig(param.read("mailConfig"));
        this.overrideSudoBaseUrl = param.read("overrideSudoBaseUrl");
        this.messagingCenterUrl = param.read("messagingCenterUrl");
        this.messagingCenterKey = param.read("messagingCenterKey");
        this.s3StorageEndPoint = param.read("s3StorageEndPoint");
        this.s3StorageLogin = param.read("s3StorageLogin");
        this.s3StoragePassword = param.read("s3StoragePassword");
        this.s3StorageBucket = param.read("s3StorageBucket");
        this.s3StorageKeyPrefix = param.read("s3StorageKeyPrefix");
        this.localCacheDir = param.read("localCacheDir");
        this.localCacheSize = param.read("localCacheSize");
        String dbms = param.read("dbms");
        this.dbmsConf = this.createDbmsConf(dbms, param);
        this.dbmsConf.load(param);
        this.masterConf = this.createMasterConf(param);
    }

    private MailConfig readMailConfig(String read) {
        EnumSet<MailConfig> enums = EnumSet.allOf(MailConfig.class);
        for (MailConfig en : enums) {
            if (!en.name().equalsIgnoreCase(read)) continue;
            return en;
        }
        return MailConfig.NO_MAIL;
    }

    private AppInstanceDTO createMasterConf(ServletParameter param) {
        AppInstanceDTO dto = new AppInstanceDTO();
        dto.id = 0L;
        dto.nomInstance = param.read("master.name");
        dto.dbUserName = param.read("master.user");
        dto.dbPassword = param.read("master.password");
        dto.dateCreation = new Date(0L);
        return dto;
    }

    private DBMSConf createDbmsConf(String dbmsName, ServletParameter param) {
        DBMSConf res;
        String type = param.read("dbms." + dbmsName + ".type");
        if (type.equals("hsql_internal")) {
            res = new HsqlInternalDbmsConf(dbmsName);
        } else if (type.equals("hsql_external")) {
            res = new HsqlExternalDbmsConf(dbmsName);
        } else {
            throw new AmapjRuntimeException("Le type <" + type + "> n'est pas reconnu ");
        }
        return res;
    }

    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    public DBMSConf getDbmsConf() {
        return this.dbmsConf;
    }

    public AppInstanceDTO getMasterConf() {
        return this.masterConf;
    }

    public boolean isAdminFull() {
        return this.adminFull;
    }

    public boolean isAllowTimeControl() {
        return this.allowTimeControl;
    }

    public boolean isStatusPageAllowed() {
        return this.statusPageAllowed;
    }

    public String getBackupCommand() {
        return this.backupCommand;
    }

    public String getMaintenanceKey() {
        return this.maintenanceKey;
    }

    public String getWkhtmltopdfCommand() {
        return this.wkhtmltopdfCommand;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getOverrideSudoBaseUrl() {
        return this.overrideSudoBaseUrl;
    }

    public String getMessagingCenterUrl() {
        return this.messagingCenterUrl;
    }

    public String getMessagingCenterKey() {
        return this.messagingCenterKey;
    }

    public MailConfig getMailConfig() {
        return this.mailConfig;
    }

    public boolean isPdfConversionWithMessagingCenter() {
        return this.pdfConversionWithMessagingCenter;
    }

    public String getS3StorageEndPoint() {
        return this.s3StorageEndPoint;
    }

    public String getS3StorageLogin() {
        return this.s3StorageLogin;
    }

    public String getS3StoragePassword() {
        return this.s3StoragePassword;
    }

    public String getS3StorageBucket() {
        return this.s3StorageBucket;
    }

    public String getS3StorageKeyPrefix() {
        return this.s3StorageKeyPrefix;
    }

    public String getLocalCacheDir() {
        return this.localCacheDir;
    }

    public String getLocalCacheSize() {
        return this.localCacheSize;
    }

    public static void initializeForTesting() {
        mainInstance = new AppConfiguration();
        Properties prop = new Properties();
        prop.put("dbms", "he");
        prop.put("dbms.he.type", "hsql_external");
        prop.put("dbms.he.ip", "127.0.0.1");
        prop.put("dbms.he.port", "9001");
        prop.put("master.dbms", "he");
        prop.put("master.name", "master");
        prop.put("master.user", "SA");
        prop.put("master.password", "");
        prop.put("logDir", "../logs/");
        MockServletParameter param = new MockServletParameter(prop);
        mainInstance.loadInternal(param);
    }

    public static void initializeForUnitTesting() {
        mainInstance = new AppConfiguration();
        Properties prop = new Properties();
        prop.put("dbms", "hi");
        prop.put("dbms.hi.type", "hsql_internal");
        prop.put("dbms.hi.port", "9500");
        prop.put("dbms.hi.dir", String.valueOf(DevPath.amapjdev()) + "/tests-units/db/data");
        prop.put("master.dbms", "hi");
        prop.put("master.name", "master");
        prop.put("mailConfig", "storage");
        prop.put("logDir", "../../logs/");
        prop.put("wkhtmltopdf", "wkhtmltopdf");
        prop.put("s3StorageEndPoint", "http://127.0.0.1:9000/");
        prop.put("s3StorageLogin", "s3login");
        prop.put("s3StoragePassword", "s3password");
        prop.put("s3StorageBucket", "abucket");
        prop.put("s3StorageKeyPrefix", "slot1");
        prop.put("localCacheDir", String.valueOf(DevPath.amapj()) + "/serverfiles/tests-units/localcache");
        prop.put("localCacheSize", "1000");
        MockServletParameter param = new MockServletParameter(prop);
        mainInstance.loadInternal(param);
    }

    public static enum MailConfig {
        NO_MAIL,
        GMAIL,
        POSTFIX_LOCAL,
        MESSAGING_CENTER,
        STORAGE;

    }
}

