/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.advanced.devtools;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.service.services.mailer.MailerCounter;
import fr.amapj.view.engine.popup.cascadingpopup.sample.ABCSample;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.engine.template.BackOfficeLongView;
import fr.amapj.view.engine.ui.AppConfiguration;
import fr.amapj.view.views.advanced.devtools.DevToolsComplexTableBuilder;
import fr.amapj.view.views.advanced.devtools.DevToolsSelectionTable;
import fr.amapj.view.views.advanced.devtools.DevToolsTabDemo;
import fr.amapj.view.views.advanced.devtools.PopupDecodeZipField;
import fr.amapj.view.views.advanced.devtools.PopupHtmlToPdf;
import fr.amapj.view.views.advanced.devtools.PopupJpaEntityEquality;
import fr.amapj.view.views.advanced.devtools.PopupMailStorage;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DevToolsView
extends BackOfficeLongView
implements View {
    private static final Logger logger = LogManager.getLogger();
    Label labelDateHeure;
    TextField textDateHeure;
    static List<MyObject[]> ls = new ArrayList<MyObject[]>();

    @Override
    public String getMainStyleName() {
        return "maintenance";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        Button b;
        boolean allowTimeControl = AppConfiguration.getConf().isAllowTimeControl();
        boolean allowMailControl = AppConfiguration.getConf().getMailConfig() == AppConfiguration.MailConfig.STORAGE;
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.addLabel(this, "Outils pour le developpement", "titre");
        HorizontalLayout hl = new HorizontalLayout();
        hl.addComponent((Component)new Label("Date et heure courante :"));
        String valDate = df.format(DateUtils.getDate());
        this.labelDateHeure = new Label(valDate);
        hl.addComponent((Component)this.labelDateHeure);
        if (allowTimeControl) {
            this.textDateHeure = new TextField();
            this.textDateHeure.setWidth("200px");
            this.textDateHeure.setValue(valDate);
            hl.addComponent((Component)this.textDateHeure);
            b = new Button("Control time");
            hl.addComponent((Component)b);
            b.addClickListener((Button.ClickListener & Serializable)e -> this.controlTime());
        }
        this.addComponent((Component)hl);
        this.addLabel(this, "Nombre d'emails envoy\u00e9s aujourd'hui : " + MailerCounter.getNbMails());
        if (allowMailControl) {
            b = new Button("Visualiser tous les mails locaux");
            this.addComponent((Component)b);
            b.addClickListener((Button.ClickListener & Serializable)e -> this.controlMail());
        }
        Panel devToolsPanel = new Panel("Outils de d\u00e9veloppement");
        devToolsPanel.addStyleName("action");
        devToolsPanel.setContent(this.getDevToolsPanel());
        this.addComponent((Component)devToolsPanel);
    }

    private void controlMail() {
        PopupMailStorage.open(new PopupMailStorage());
    }

    private void controlTime() {
        String str = (String)this.textDateHeure.getValue();
        if (str.length() != 19) {
            MessagePopup p = new MessagePopup("Erreur", CorePopup.ColorStyle.RED, "Erreur dans le format - il faut 19 caract\u00e8res");
            MessagePopup.open(p);
            return;
        }
        DateUtils.developperModeSetDate(str);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.labelDateHeure.setValue(df.format(DateUtils.getDate()));
    }

    private Component getDevToolsPanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addEmptyLine(layout);
        this.addLabel(layout, "Outils divers r\u00e9serv\u00e9s aux experts.");
        this.addEmptyLine(layout);
        this.addLabel(layout, "ATTENTION !!! Ne pas utiliser sur une base en production !!! ATTENTION !!!!.");
        Button b99 = new Button("D\u00e9coder le contenu d'un champ zipp\u00e9", (Button.ClickListener & Serializable)e -> this.decodeZipField());
        Button b0 = new Button("G\u00e9n\u00e9rer une erreur", (Button.ClickListener & Serializable)e -> this.generateEror());
        Button b10 = new Button("G\u00e9n\u00e9rer une requete longue (60secondes)", (Button.ClickListener & Serializable)e -> this.generateLongWait());
        Button b1 = new Button("Test du cascading de popup ", (Button.ClickListener & Serializable)e -> this.cascading());
        layout.addComponent((Component)b1);
        this.addEmptyLine(layout);
        Button b2 = new Button("Test des popup de type tab", (Button.ClickListener & Serializable)e -> CorePopup.open(new DevToolsTabDemo()));
        Button b3 = new Button("La selection dans une table", (Button.ClickListener & Serializable)e -> CorePopup.open(new DevToolsSelectionTable()));
        Button b4 = new Button("La gestion des entit\u00e9s JPA - \u00e9galit\u00e9", (Button.ClickListener & Serializable)e -> this.jpaEntity());
        Button b5 = new Button("Transformation HTML To Pdf", (Button.ClickListener & Serializable)e -> this.htmlToPdf());
        Button b6 = new Button("Test du Complex Table Builder", (Button.ClickListener & Serializable)e -> CorePopup.open(new DevToolsComplexTableBuilder()));
        layout.addComponent((Component)b99);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b0);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b10);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b1);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b2);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b3);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b4);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b5);
        this.addEmptyLine(layout);
        layout.addComponent((Component)b6);
        this.addEmptyLine(layout);
        return layout;
    }

    private void decodeZipField() {
        PopupDecodeZipField.open(new PopupDecodeZipField());
    }

    private void jpaEntity() {
        PopupJpaEntityEquality.open(new PopupJpaEntityEquality());
    }

    private void htmlToPdf() {
        PopupHtmlToPdf.open(new PopupHtmlToPdf());
    }

    private void generateEror() {
        String str = null;
        str.trim();
    }

    private void generateLongWait() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void cascading() {
        ABCSample sample = new ABCSample();
        sample.doIt(null);
    }

    private void performLeakMemory() {
        int n = 1000000;
        MyObject[] obs = new MyObject[n];
        int i = 0;
        while (i < n) {
            obs[i] = new MyObject();
            obs[i].a = i;
            obs[i].b = 2 * i;
            obs[i].w = "toto" + i;
            ++i;
        }
        ls.add(obs);
    }

    private Label addLabel(VerticalLayout layout, String str, String stylename) {
        Label tf = new Label(str);
        if (stylename != null) {
            tf.addStyleName(stylename);
        }
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addLabel(VerticalLayout layout, String str) {
        return this.addLabel(layout, str, null);
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        tf.addStyleName("big");
        layout.addComponent((Component)tf);
        return tf;
    }

    static class MyObject {
        int a;
        long b;
        String w;

        MyObject() {
        }
    }
}

