/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.advanced.devtools;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Link;
import com.vaadin.ui.TextArea;
import fr.amapj.service.engine.generator.pdf.Html2PdfConverter;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PopupHtmlToPdf
extends WizardFormPopup {
    private TextArea tf;

    public PopupHtmlToPdf() {
        this.setWidth(80);
        this.popupTitle = "Transformation HTML vers PDF";
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldSaisie());
    }

    private void addFieldSaisie() {
        this.setStepTitle("Conversion");
        this.tf = new TextArea("Contenu html");
        this.tf.setWidth("90%");
        this.tf.setHeight(10.0f, Sizeable.Unit.CM);
        this.tf.setImmediate(true);
        this.form.addComponent((Component)this.tf);
        StreamResource streamResource = new StreamResource((StreamResource.StreamSource)new PdfResource(this.tf), "test.pdf");
        streamResource.setCacheTime(1000L);
        Link extractFile = new Link("T\u00e9l\u00e9charger le pdf", (Resource)streamResource);
        extractFile.setIcon((Resource)FontAwesome.DOWNLOAD);
        extractFile.setTargetName("_blank");
        this.form.addComponent((Component)extractFile);
    }

    @Override
    protected void performSauvegarder() {
    }

    public static class PdfResource
    implements StreamResource.StreamSource {
        private TextArea t;

        public PdfResource(TextArea t) {
            this.t = t;
        }

        public InputStream getStream() {
            String content = (String)this.t.getValue();
            byte[] b = new Html2PdfConverter().convertHtmlToPdf(content);
            return new ByteArrayInputStream(b);
        }
    }
}

