/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.advanced.maintenance;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.common.DateUtils;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.services.advanced.maintenance.MaintenanceService;
import fr.amapj.service.services.backupdb.BackupDatabaseService;
import fr.amapj.service.services.mailer.MailerCounter;
import fr.amapj.view.engine.template.BackOfficeLongView;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaintenanceView
extends BackOfficeLongView
implements View {
    private static final Logger logger = LogManager.getLogger();
    Label labelDateHeure;
    TextField textDateHeure;

    @Override
    public String getMainStyleName() {
        return "maintenance";
    }

    @Override
    public void enterIn(ViewChangeListener.ViewChangeEvent event) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.addLabel(this, "Maintenance du syst\u00e8me", "titre");
        this.addLabel(this, "Date et heure courante :" + df.format(DateUtils.getDate()));
        this.addLabel(this, "Version de l'application : " + new MaintenanceService().getVersion());
        this.addLabel(this, "Type de serveur mail  : " + (Object)((Object)AppConfiguration.getConf().getMailConfig()));
        this.addLabel(this, "Nombre d'emails envoy\u00e9s aujourd'hui : " + MailerCounter.getNbMails());
        Panel backupPanel = new Panel("Sauvegarde de la base et envoi par e mail");
        backupPanel.addStyleName("action");
        backupPanel.setContent(this.getBackupPanel());
        this.addComponent((Component)backupPanel);
        this.addEmptyLine(this);
    }

    private Component getBackupPanel() {
        VerticalLayout layout = new VerticalLayout();
        layout.setMargin(true);
        this.addEmptyLine(layout);
        this.addLabel(layout, "Cet outil vous permet de faire une sauvegarde de la base et de l'envoyer par mail \u00e0 l'adresse param\u00e9tr\u00e9e dans les param\u00e8tres g\u00e9n\u00e9raux.");
        this.addLabel(layout, "Cet outil peut \u00eatre utilis\u00e9 avant de faire des modifications importantes sur la base.");
        this.addLabel(layout, "Cet outil permet aussi de v\u00e9rifier que les sauvegardes fonctionnent bien.");
        this.addEmptyLine(layout);
        Button b1 = new Button("Backup de la base et envoi par mail", (Button.ClickListener & Serializable)e -> new BackupDatabaseService().backupDatabase(new DeamonsContext(), "Sauvegarde manuelle"));
        layout.addComponent((Component)b1);
        this.addEmptyLine(layout);
        return layout;
    }

    private Label addLabel(VerticalLayout layout, String str, String stylename) {
        Label tf = new Label(str);
        if (stylename != null) {
            tf.addStyleName(stylename);
        }
        layout.addComponent((Component)tf);
        return tf;
    }

    private Label addLabel(VerticalLayout layout, String str) {
        return this.addLabel(layout, str, null);
    }

    private Label addEmptyLine(VerticalLayout layout) {
        Label tf = new Label("<br/>", ContentMode.HTML);
        tf.addStyleName("big");
        layout.addComponent((Component)tf);
        return tf;
    }
}

