/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.advanced.tenantnotification;

import com.vaadin.shared.ui.label.ContentMode;
import fr.amapj.messagingcenter.miniproxy.core.ServiceNotAvailableException;
import fr.amapj.service.services.advanced.tenantnotification.SmallTenantNotificationDTO;
import fr.amapj.service.services.advanced.tenantnotification.TenantNotificationService;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.messagepopup.MessagePopup;
import fr.amapj.view.views.advanced.tenantnotification.TenantNotificationPopup;
import java.util.ArrayList;
import java.util.List;

public class TenantNotificationListPart
extends StandardListPart<SmallTenantNotificationDTO> {
    public TenantNotificationListPart() {
        super(SmallTenantNotificationDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "H\u00e9bergement AmapJ - Liste des messages";
    }

    @Override
    protected void drawButton() {
        this.addButton("Visualiser", ButtonType.EDIT_MODE, e -> this.handleVisualiser());
        this.addButtonAction("Rafraichir", ButtonType.ALWAYS, () -> this.refreshTable());
        this.addSearchField("Rechercher par titre");
    }

    @Override
    protected void drawTable() {
        this.addColumnDateTime("date", "Date").center().width(150);
        this.addColumn("title", "Titre du message");
    }

    @Override
    protected List<SmallTenantNotificationDTO> getLines() {
        try {
            return new TenantNotificationService().getAllNotifications();
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            this.popupServiceNonDisponible().open();
            return new ArrayList<SmallTenantNotificationDTO>();
        }
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"date"};
    }

    @Override
    protected boolean[] getSortAsc() {
        return new boolean[1];
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"title"};
    }

    private CorePopup handleVisualiser() {
        SmallTenantNotificationDTO dto = (SmallTenantNotificationDTO)this.getSelectedLine();
        try {
            return new TenantNotificationPopup(dto.id);
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            return this.popupServiceNonDisponible();
        }
    }

    private CorePopup popupServiceNonDisponible() {
        return new MessagePopup("Service non disponible", ContentMode.HTML, CorePopup.ColorStyle.RED, "La lecture des messages n'est pas disponible pour le moment.<br/><br/>Merci de r\u00e9 essayer plus tard.");
    }
}

