/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.appinstance;

import com.google.gson.Gson;
import fr.amapj.common.DateUtils;
import fr.amapj.common.RandomUtils;
import fr.amapj.common.StringUtils;
import fr.amapj.model.models.param.SmtpType;
import fr.amapj.model.models.saas.StateOnStart;
import fr.amapj.model.models.saas.TypDbExemple;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppInstanceService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.views.appinstance.WizardClientDTO;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppInstanceEditorPart
extends WizardFormPopup {
    private AppInstanceDTO dto;

    public AppInstanceEditorPart() {
        this.setWidth(80);
        this.popupTitle = "Cr\u00e9ation d'une instance";
        this.dto = new AppInstanceDTO();
        this.dto.stateOnStart = StateOnStart.ON_START_BE_ON;
        this.setModel(this.dto);
    }

    private String guessDefault() {
        ParametresDTO param = new ParametresService().getParametres();
        String res = param.getUrl();
        if (res.lastIndexOf(47) != -1) {
            res = res.substring(0, res.lastIndexOf(47));
            res = String.valueOf(res) + "/" + this.dto.nomInstance;
        }
        return res;
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldDemo());
        this.add(() -> this.addFieldUrlInfo());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de l'instance");
        this.addTextField("Nom", "nomInstance", new IValidator[0]);
        this.addTextField("Db UserName (si externe)", "dbUserName", new IValidator[0]);
        this.addTextField("Db Password (si externe)", "dbPassword", new IValidator[0]);
        this.addComboEnumField("Base de d\u00e9part", "typDbExemple", new IValidator[0]);
    }

    private void addFieldDemo() {
        this.computeData();
        this.setStepTitle("les informations pour la cr\u00e9ation de la base");
        if (this.dto.typDbExemple == TypDbExemple.BASE_EXEMPLE) {
            this.addTextField("Nom de l'AMAP qui sera affich\u00e9", "nomAmap", new IValidator[0]);
            this.addTextField("Ville de l'AMAP", "villeAmap", new IValidator[0]);
            this.addComboEnumField("Type du serveur de mail", "smtpType", new NotNullValidator());
            this.addTextField("Adresse mail expediteur", "adrMailSrc", new IValidator[0]);
            this.addIntegerField("Nombre maximum de mail par jour", "nbMailMax", new IValidator[0]);
            this.addTextField("Url vue par les utilisateurs", "url", new IValidator[0]);
            this.addDateField("Date de fin des inscriptions", "dateFinInscription", new IValidator[0]);
            this.addDateField("Date de d\u00e9but des distributions", "dateDebut", new IValidator[0]);
            this.addDateField("Date de fin des distributions", "dateFin", new IValidator[0]);
            this.addTextField("Password des utilisateurs", "password", new IValidator[0]);
        } else {
            this.addTextField("Nom de l'AMAP qui sera affich\u00e9", "nomAmap", new IValidator[0]);
            this.addTextField("Ville de l'AMAP", "villeAmap", new IValidator[0]);
            this.addComboEnumField("Type du serveur de mail", "smtpType", new NotNullValidator());
            this.addTextField("Adresse mail expediteur", "adrMailSrc", new IValidator[0]);
            this.addIntegerField("Nombre maximum de mail par jour", "nbMailMax", new IValidator[0]);
            this.addTextField("Url vue par les utilisateurs", "url", new IValidator[0]);
            this.addTextField("Nom de l'administrateur", "user1Nom", new IValidator[0]);
            this.addTextField("Pr\u00e9nom de l'administrateur", "user1Prenom", new IValidator[0]);
            this.addTextField("Email de l'administrateur", "user1Email", new IValidator[0]);
            this.addTextField("Password de l'administrateur", "password", new IValidator[0]);
        }
    }

    private void computeData() {
        if (this.dto.nomInstance.contains("{")) {
            this.loadData();
        } else {
            this.computeClassicData();
        }
    }

    private void computeClassicData() {
        this.dto.url = this.guessDefault();
        switch (this.dto.typDbExemple) {
            case BASE_EXEMPLE: {
                this.dto.smtpType = SmtpType.POSTFIX_LOCAL;
                this.dto.adrMailSrc = "demo@m.amapj.fr";
                this.dto.nbMailMax = 5;
                break;
            }
            case BASE_MINIMALE: {
                this.dto.smtpType = SmtpType.POSTFIX_LOCAL;
                this.dto.adrMailSrc = String.valueOf(this.dto.nomInstance) + "@m.amapj.fr";
                this.dto.nbMailMax = 200;
            }
        }
        if (this.dto.typDbExemple == TypDbExemple.BASE_EXEMPLE) {
            Date d1 = DateUtils.addDays(DateUtils.getDate(), 35);
            Date d2 = DateUtils.firstMonday(d1);
            Date d3 = DateUtils.addDays(d2, 3);
            Date d4 = DateUtils.addDays(d2, 84);
            this.dto.dateDebut = d3;
            this.dto.dateFin = d4;
            this.dto.dateFinInscription = d3;
            this.dto.password = RandomUtils.generatePasswordMin(8);
        } else {
            this.dto.password = RandomUtils.generatePasswordMin(16);
        }
    }

    private void loadData() {
        WizardClientDTO c = (WizardClientDTO)new Gson().fromJson(this.dto.nomInstance, WizardClientDTO.class);
        this.dto.nomInstance = c.code;
        this.dto.typDbExemple = TypDbExemple.BASE_MINIMALE;
        this.dto.nomAmap = c.nom;
        this.dto.villeAmap = c.ville;
        this.dto.smtpType = SmtpType.POSTFIX_LOCAL;
        this.dto.adrMailSrc = String.valueOf(this.dto.nomInstance) + "@m.amapj.fr";
        this.dto.nbMailMax = 200;
        this.dto.url = c.url;
        this.dto.user1Nom = c.contact1Nom;
        this.dto.user1Prenom = c.contact1Prenom;
        this.dto.user1Email = c.contact1Email;
        this.dto.password = c.contact1Password;
    }

    private void addFieldUrlInfo() {
        this.setStepTitle("le mail \u00e0 envoyer");
        String str = null;
        str = this.dto.typDbExemple == TypDbExemple.BASE_EXEMPLE ? this.getInfoDemo() : this.getInfoProd();
        this.addHtml(str);
    }

    private String getInfoProd() {
        String str = "<br/>Bonjour <br/>votre AmapJ de production est accessible avec ce lien :<br/><br/>" + this.dto.url + "<br/><br/>" + "Il y a un seul utilisateur avec les caract\u00e9ristiques suivantes :<br/><br/>" + "Nom: " + this.dto.user1Nom + "<br/>" + "Prenom: " + this.dto.user1Prenom + "<br/>" + "Email: " + this.dto.user1Email + "<br/>" + "Password: " + this.dto.password + "<br/><br/>" + "Cet utilisateur est ADMINISTRATEUR, merci de changer d\u00e8s que possible le mot de passe.";
        return str;
    }

    private String getInfoDemo() {
        String str = "<br/>Bonjour <br/>vous pouvez tester le logiciel AmapJ avec ce lien :<br/><br/>" + this.dto.url + "<br/><br/>" + "Les instructions pour une visite guid\u00e9e sont ici :<br/><br/>" + this.getUrl() + "<br/><br/>" + "Ce lien vous donnera les login et les mots de passe \u00e0 utiliser.<br/>" + " Je vous  conseille de suivre pas \u00e0 pas les indications de cette page, <br/>" + "cela vous  permettra  de comprendre le fonctionnement  du logiciel";
        return str;
    }

    private String getUrl() {
        return "http://amapj.fr/docs_utilisateur_visite_guidee.html?d1=" + this.getDate(this.dto.dateFinInscription) + "&" + "d2=" + this.getDate(this.dto.dateFinInscription) + "&" + "d3=" + this.getDate(this.dto.dateDebut) + "&" + "d4=" + this.getDate(this.dto.dateFin) + "&" + "pass=" + this.dto.password;
    }

    private String getDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("EEEEE dd MMMMM yyyy");
        String str = df.format(date);
        str = str.replaceAll(" ", "_");
        return StringUtils.sansAccent(str);
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new AppInstanceService().create(this.dto);
    }
}

