/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.appinstance;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Link;
import com.vaadin.ui.UI;
import fr.amapj.service.engine.sudo.SudoManager;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppInstanceService;
import fr.amapj.service.services.appinstance.ChoixSudoUtilisateurDTO;
import fr.amapj.service.services.appinstance.SudoUtilisateurDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.util.List;

public class PopupConnectAppInstance
extends WizardFormPopup {
    private ChoixSudoUtilisateurDTO selected;
    private AppInstanceDTO appInstanceDTO;

    public PopupConnectAppInstance(AppInstanceDTO dto) {
        this.popupTitle = "Connection en tant que ...";
        this.saveButtonTitle = "OK";
        this.appInstanceDTO = dto;
        this.selected = new ChoixSudoUtilisateurDTO();
        this.setModel(this.selected);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldConnexion());
    }

    private void addFieldGeneral() {
        List<SudoUtilisateurDTO> sudoUtilisateurDTOs = new AppInstanceService().getSudoUtilisateurDto(this.appInstanceDTO);
        this.setStepTitle("choisir son utilisateur");
        this.addGeneralComboField("Utilisateur", sudoUtilisateurDTOs, "selected", null, new IValidator[0]);
    }

    private void addFieldConnexion() {
        String overrideSudoBaseUrl = AppConfiguration.getConf().getOverrideSudoBaseUrl();
        String baseUrl = overrideSudoBaseUrl != null ? String.valueOf(overrideSudoBaseUrl) + "/" + this.appInstanceDTO.nomInstance + this.selected.selected.emailUrl : String.valueOf(this.selected.selected.baseUrl) + this.selected.selected.emailUrl;
        String nomInstance = this.appInstanceDTO.nomInstance;
        String session = UI.getCurrent().getSession().getCsrfToken();
        String sudoKey = SudoManager.addSudoCredential(this.selected.selected, nomInstance, session);
        String url = String.valueOf(baseUrl) + "&sudo=" + sudoKey;
        this.setStepTitle("cliquer sur le lien si dessous pour ouvrir l'application");
        Link link = new Link("Lien de connexion", (Resource)new ExternalResource(url));
        link.setTargetName("_blank");
        this.form.addComponent((Component)link);
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
    }
}

