/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.appinstance;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.TextArea;
import fr.amapj.common.CollectionUtils;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppInstanceService;
import fr.amapj.service.services.appinstance.SqlRequestDTO;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import java.util.ArrayList;
import java.util.List;

public class PopupSqlAppInstance
extends WizardFormPopup {
    private SqlRequestDTO selected;
    private List<AppInstanceDTO> appInstanceDTOs;

    public PopupSqlAppInstance(List<AppInstanceDTO> appInstanceDTOs) {
        this.popupTitle = "Executer des requetes SQL";
        this.setWidth(90);
        this.saveButtonTitle = "OK";
        this.appInstanceDTOs = appInstanceDTOs;
        CollectionUtils.sort(this.appInstanceDTOs, e -> e.nomInstance);
        this.selected = new SqlRequestDTO();
        this.setModel(this.selected);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addRequest());
        this.add(() -> this.addAffichageRequest());
        this.add(() -> this.addAffichageResult());
    }

    private void addFieldGeneral() {
        this.setStepTitle("informations");
        this.addComboEnumField("Type des requetes", "sqlType", new IValidator[0]);
        String str = "Cet outil permet d'executer X requetes SQL sur les bases s\u00e9lectionn\u00e9es<br/><br/>";
        str = String.valueOf(str) + "Le nombre de bases est : " + this.appInstanceDTOs.size() + " bases<br/><br/>";
        str = String.valueOf(str) + "Liste des bases <br/>";
        for (AppInstanceDTO appInstanceDTO : this.appInstanceDTOs) {
            str = String.valueOf(str) + appInstanceDTO.nomInstance + "<br/>";
        }
        this.addHtml(str);
    }

    private void addRequest() {
        this.setStepTitle("saisir la liste des requetes SQL");
        TextArea f = this.addTextAeraField("Listes des requetes", "requests");
        f.setHeight(8.0f, Sizeable.Unit.CM);
    }

    private void addAffichageRequest() {
        this.setStepTitle("v\u00e9rifier les requetes SQL");
        this.computeRequest();
        String str = "Il y a " + this.selected.verifiedRequests.size() + " requetes \u00e0 executer<br/><br/>" + "Voici la liste des requetes :<br/><br/>";
        int index = 1;
        for (String s : this.selected.verifiedRequests) {
            str = String.valueOf(str) + "Requete " + index + "<br/>" + PopupSqlAppInstance.s(s) + "<br/><br/>";
            ++index;
        }
        this.addHtml(str);
    }

    private void computeRequest() {
        this.selected.verifiedRequests = new ArrayList<String>();
        String a = this.selected.requests.replaceAll("\r\n", "\n");
        a = a.replaceAll("\n\r", "\n");
        a = String.valueOf(a) + "\n";
        String[] rs = a.split(";\n");
        int i = 0;
        while (i < rs.length) {
            String r = rs[i].trim();
            if (r.length() > 0) {
                this.selected.verifiedRequests.add(r);
            }
            ++i;
        }
    }

    private void addAffichageResult() {
        new AppInstanceService().executeSqlRequest(this.selected, this.appInstanceDTOs);
        this.setStepTitle("r\u00e9sultats des requetes SQL");
        String str = "";
        str = this.selected.success ? String.valueOf(str) + "SUCCESS <br/><br/>" : String.valueOf(str) + "<h1>!!! ECHEC !!! </h1><br/><br/>";
        for (SqlRequestDTO.DataBaseResponseDTO dataBase : this.selected.responses) {
            str = String.valueOf(str) + this.addDataBase(dataBase);
        }
        this.addHtml(str);
    }

    private String addDataBase(SqlRequestDTO.DataBaseResponseDTO dataBase) {
        String str = "";
        str = this.selected.success ? String.valueOf(str) + "OK pour la base " + dataBase.dbName + " <br/><br/>" : String.valueOf(str) + "<h1>!!! ECHEC !!! pour la base " + dataBase.dbName + "</h1><br/><br/>";
        for (SqlRequestDTO.ResponseDTO responseDTO : dataBase.responses) {
            str = String.valueOf(str) + "Requete " + responseDTO.index + " : " + responseDTO.sqlRequest + "<br/>";
            str = String.valueOf(str) + PopupSqlAppInstance.s(responseDTO.sqlResponse) + "<br/><br/>";
            if (this.selected.sqlType != SqlRequestDTO.SqlType.REQUETE_SQL_STANDARD) continue;
            str = String.valueOf(str) + "<table>";
            List<List<String>> lines = responseDTO.sqlResultSet;
            if (lines != null) {
                for (List<String> ls : lines) {
                    str = String.valueOf(str) + " <tr>";
                    for (String string : ls) {
                        if (string != null) {
                            string = PopupSqlAppInstance.s(string);
                        }
                        str = String.valueOf(str) + "<td>" + string + "</td>";
                    }
                    str = String.valueOf(str) + " </tr>";
                }
            }
            str = String.valueOf(str) + " </table>";
            str = String.valueOf(str) + "<br/><br/>";
        }
        return str;
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
    }
}

