/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import fr.amapj.service.services.archivage.ArchivageContratService;
import fr.amapj.service.services.archivage.ArchivageUtilisateurService;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.permanence.periode.PeriodePermanenceService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.views.archivage.gestion.PopupSaisieNombreJour;
import java.io.Serializable;

public class PopupSaisieParametresArchivage
extends WizardFormPopup {
    private ParametresArchivageDTO dto;

    public PopupSaisieParametresArchivage() {
        this.setWidth(80);
        this.popupTitle = "Modification des param\u00e8tres d'archivage";
        this.dto = new ParametresService().getParametresArchivage();
        this.setModel(this.dto);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldContrat());
        this.add(() -> this.addFieldUtilisateur());
        this.add(() -> this.addFieldProducteur());
        this.add(() -> this.addFieldPermanence());
        this.add(() -> this.addFieldCotisation());
    }

    private void addFieldContrat() {
        this.form.removeAllComponents();
        this.setStepTitle("Param\u00e8tres d'archivage / suppression des contrats");
        String s1 = new ArchivageContratService().computeArchivageLib(this.dto);
        this.addBloc(s1, () -> this.addFieldContrat(), new PopupSaisieNombreJour.Regle("la date de derni\u00e8re livraison est plus vieille que", "archivageContrat"));
        s1 = new ArchivageContratService().computeSuppressionLib(this.dto);
        this.addBloc(s1, () -> this.addFieldContrat(), new PopupSaisieNombreJour.Regle("la date de derni\u00e8re livraison est plus vieille que", "suppressionContrat"));
    }

    private void addFieldUtilisateur() {
        this.form.removeAllComponents();
        this.setStepTitle("Param\u00e8tres d'archivage / suppression des utilisateurs");
        String s1 = new ArchivageUtilisateurService().computeArchivageLib(this.dto);
        this.addBloc(s1, () -> this.addFieldUtilisateur(), new PopupSaisieNombreJour.Regle("la date de fin de sa derni\u00e8re adh\u00e9sion ou de sa derni\u00e8re livraison est plus vieille que", "archivageUtilisateur"));
        s1 = new ArchivageUtilisateurService().computeSuppressionLib(this.dto);
        this.addBloc(s1, () -> this.addFieldUtilisateur(), new PopupSaisieNombreJour.Regle[0]);
    }

    private void addFieldProducteur() {
        this.form.removeAllComponents();
        this.setStepTitle("Param\u00e8tres d'archivage / suppression des producteurs");
        String s1 = new ProducteurService().computeArchivageLib(this.dto);
        this.addBloc(s1, () -> this.addFieldProducteur(), new PopupSaisieNombreJour.Regle("la date de derni\u00e8re livraison est plus vieille que", "archivageProducteur"));
        s1 = new ProducteurService().computeSuppressionLib(this.dto);
        this.addBloc(s1, () -> this.addFieldProducteur(), new PopupSaisieNombreJour.Regle[0]);
    }

    private void addFieldPermanence() {
        this.form.removeAllComponents();
        this.setStepTitle("Param\u00e8tres de suppression des p\u00e9riodes de permanence");
        String s1 = new PeriodePermanenceService().computeSuppressionLib(this.dto);
        this.addBloc(s1, () -> this.addFieldPermanence(), new PopupSaisieNombreJour.Regle("la date de fin de cette p\u00e9riode de permanence est plus vieille que", "suppressionPeriodePermanence"));
    }

    private void addFieldCotisation() {
        this.form.removeAllComponents();
        this.setStepTitle("Param\u00e8tres de suppression des p\u00e9riodes de cotisation");
        String s1 = new GestionCotisationService().computeSuppressionLib(this.dto);
        this.addBloc(s1, () -> this.addFieldCotisation(), new PopupSaisieNombreJour.Regle("la date de fin de cette p\u00e9riode de cotisation est plus vieille que", "suppressionPeriodeCotisation"));
    }

    private void addBloc(String s1, PopupListener listener, PopupSaisieNombreJour.Regle ... regles) {
        this.addHtml(s1);
        if (regles.length > 0) {
            Button b = new Button("Modifier cette r\u00e9gle", (Button.ClickListener & Serializable)e -> new PopupSaisieNombreJour(this.dto, regles).open(listener));
            this.form.addComponent((Component)b);
        } else {
            this.addHtml("Regle non modifiable");
        }
        this.addHtml("");
    }

    @Override
    protected void performSauvegarder() {
        new ParametresService().updateParametresArchivage(this.dto);
    }
}

