/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProducteurDTO;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupSuppressionProducteur
extends WizardFormPopup {
    private ComplexTableBuilder<ProducteurDTO> builder;
    private List<ProducteurDTO> toSuppress;
    private List<ProducteurDTO> dtos;
    private ParametresArchivageDTO param;

    public PopupSuppressionProducteur() {
        this.setWidth(80);
        this.popupTitle = "Suppression des producteurs archiv\u00e9s trop anciens";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieContrat(), () -> this.readContratsToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des producteurs qu'il est souhaitable de supprimer";
        this.addHtml(str);
        str = new ProducteurService().computeSuppressionLib(this.param);
        this.addHtml(str);
    }

    private void addFieldSaisieContrat() {
        this.setStepTitle("les producteurs \u00e0 supprimer");
        this.dtos = new ProducteurService().getAllProducteurSupprimables(this.param);
        this.toSuppress = new ArrayList<ProducteurDTO>();
        if (this.dtos.size() == 0) {
            this.addHtml("Il n'y a pas de producteurs \u00e0 supprimer.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<ProducteurDTO>(this.dtos);
        this.builder.setPageLength(7);
        this.builder.addString("Nom du producteur", false, 300, e -> e.nom);
        this.builder.addDate("Date de cr\u00e9ation du producteur", false, 150, e -> e.dateCreation);
        this.builder.addCheckBox("Supprimer ce producteur", "cb", true, 150, e -> true, null);
        this.addComplexTable(this.builder);
    }

    private String readContratsToArchive() {
        this.toSuppress = this.builder.getSelectedCheckBox("cb");
        if (this.toSuppress.size() == 0) {
            return "Vous devez selectionner au moins un producteur pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez supprimer DEFINITIVEMENT " + this.toSuppress.size() + " producteurs");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (ProducteurDTO mc : this.toSuppress) {
            try {
                new ProducteurService().deleteWithProduit(mc.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible de supprimer le producteur " + mc.nom + ". Raison : " + e.getMessage());
            }
        }
    }
}

