/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.archivage.gestion;

import fr.amapj.service.services.archivage.ArchivageUtilisateurService;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.tools.table.complex.ComplexTableBuilder;
import java.util.ArrayList;
import java.util.List;

public class PopupSuppressionUtilisateur
extends WizardFormPopup {
    private ComplexTableBuilder<UtilisateurDTO> builder;
    private List<UtilisateurDTO> toSuppress;
    private List<UtilisateurDTO> dtos;
    private ParametresArchivageDTO param;

    public PopupSuppressionUtilisateur() {
        this.setWidth(80);
        this.popupTitle = "Suppression des utilisateurs archiv\u00e9s trop anciens";
        this.param = new ParametresService().getParametresArchivage();
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldInfoGenerales());
        this.add(() -> this.addFieldSaisieContrat(), () -> this.readContratsToArchive());
        this.add(() -> this.addFieldConfirmation());
    }

    private void addFieldInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales.");
        String str = "Cet outil va rechercher la liste des utilisateurs archiv\u00e9s qu'il est souhaitable de supprimer";
        this.addHtml(str);
        str = new ArchivageUtilisateurService().computeSuppressionLib(this.param);
        this.addHtml(str);
    }

    private void addFieldSaisieContrat() {
        this.setStepTitle("les utilisateurs archiv\u00e9s \u00e0 supprimer");
        this.dtos = new ArchivageUtilisateurService().getAllUtilisateurSupprimables(this.param);
        this.toSuppress = new ArrayList<UtilisateurDTO>();
        if (this.dtos.size() == 0) {
            this.addHtml("Il n'y a pas d'utilisateurs \u00e0 supprimer.");
            this.setBackOnlyMode();
            return;
        }
        this.builder = new ComplexTableBuilder<UtilisateurDTO>(this.dtos);
        this.builder.setPageLength(7);
        this.builder.addString("Nom ", false, 200, e -> e.nom);
        this.builder.addString("Pr\u00e9nom", false, 200, e -> e.prenom);
        this.builder.addDate("Date de cr\u00e9ation", false, 150, e -> e.dateCreation);
        this.builder.addCheckBox("Supprimer cet utilisateur", "cb", true, 150, e -> true, null);
        this.addComplexTable(this.builder);
    }

    private String readContratsToArchive() {
        this.toSuppress = this.builder.getSelectedCheckBox("cb");
        if (this.toSuppress.size() == 0) {
            return "Vous devez selectionner au moins un utilisateur pour pouvoir continuer.";
        }
        return null;
    }

    private void addFieldConfirmation() {
        this.setStepTitle("confirmation");
        this.addHtml("Vous allez supprimer DEFINITIVEMENT " + this.toSuppress.size() + " utilisateurs");
        this.addHtml("Appuyez sur Sauvegarder pour r\u00e9aliser cette modification, ou Annuler pour ne rien modifier");
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        for (UtilisateurDTO mc : this.toSuppress) {
            try {
                new UtilisateurService().deleteUtilisateur(mc.id);
            }
            catch (Exception e) {
                throw new OnSaveException("Impossible de supprimer l'utilisateur " + mc.nom + " " + mc.prenom + ". Raison : " + e.getMessage());
            }
        }
    }
}

