/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.common.contratselector;

import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.searcher.SearcherList;
import java.io.Serializable;
import java.util.List;

public class ContratSelectorPart {
    private Searcher producteurBox;
    private ComboBox contratBox;
    private Button reinitButton;
    private Long idModeleContrat;
    private List<Producteur> allowedProducteurs;
    private PopupListener listener;
    private boolean onlyOneProducteur;

    public ContratSelectorPart(PopupListener listener, boolean producteurActifOnly) {
        this.listener = listener;
        this.allowedProducteurs = new AccessManagementService().getAccessLivraisonProducteur(SessionManager.getUserRoles(), SessionManager.getUserId(), producteurActifOnly);
        this.onlyOneProducteur = this.allowedProducteurs.size() == 1;
    }

    public HorizontalLayout getChoixContratComponent() {
        HorizontalLayout toolbar1 = new HorizontalLayout();
        toolbar1.addStyleName("contrat-selectorpart");
        Label pLabel = new Label("Producteur");
        pLabel.addStyleName("combobox");
        pLabel.setSizeUndefined();
        this.producteurBox = new Searcher(SearcherList.PRODUCTEUR, null, this.allowedProducteurs);
        this.producteurBox.setImmediate(true);
        this.producteurBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleProducteurChange());
        Label cLabel = new Label("Contrat");
        cLabel.addStyleName("combobox");
        cLabel.setSizeUndefined();
        this.contratBox = new ComboBox();
        this.contratBox.setImmediate(true);
        this.contratBox.setWidth("300px");
        this.contratBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleContratChange());
        this.reinitButton = new Button("Changer de contrat");
        this.reinitButton.addClickListener((Button.ClickListener & Serializable)e -> this.handleReinit());
        toolbar1.addComponent((Component)pLabel);
        toolbar1.addComponent((Component)this.producteurBox);
        toolbar1.addComponent((Component)cLabel);
        toolbar1.addComponent((Component)this.contratBox);
        if (!this.onlyOneProducteur) {
            toolbar1.addComponent((Component)this.reinitButton);
            toolbar1.setExpandRatio((Component)this.reinitButton, 1.0f);
            toolbar1.setComponentAlignment((Component)this.reinitButton, Alignment.TOP_RIGHT);
            this.contratBox.setEnabled(false);
        } else {
            Label tf = new Label("");
            toolbar1.addComponent((Component)tf);
            toolbar1.setExpandRatio((Component)tf, 1.0f);
            toolbar1.setComponentAlignment((Component)tf, Alignment.TOP_RIGHT);
        }
        toolbar1.setSpacing(true);
        toolbar1.setWidth("100%");
        return toolbar1;
    }

    public void fillAutomaticValues() {
        if (this.onlyOneProducteur) {
            Producteur prod = this.allowedProducteurs.get(0);
            this.producteurBox.setConvertedValue(prod.getId());
            this.handleProducteurChange();
        }
    }

    protected void handleReinit() {
        this.producteurBox.setValue(null);
        this.producteurBox.setEnabled(true);
        this.contratBox.setEnabled(false);
        this.idModeleContrat = null;
        this.listener.onPopupClose();
    }

    private void handleProducteurChange() {
        this.idModeleContrat = null;
        Long idProducteur = (Long)this.producteurBox.getConvertedValue();
        if (idProducteur == null) {
            this.contratBox.removeAllItems();
            this.contratBox.setEnabled(false);
        } else {
            this.contratBox.setEnabled(true);
            this.producteurBox.setEnabled(false);
            this.contratBox.removeAllItems();
            List<ModeleContrat> mcs = new GestionContratSigneService().getModeleContratCreationOrActif(idProducteur);
            for (ModeleContrat mc : mcs) {
                this.contratBox.addItem((Object)mc.getId());
                this.contratBox.setItemCaption((Object)mc.getId(), mc.nom);
            }
            if (this.contratBox.getItemIds().size() == 1) {
                this.contratBox.select(this.contratBox.getItemIds().iterator().next());
            }
        }
        this.listener.onPopupClose();
    }

    private void handleContratChange() {
        this.idModeleContrat = (Long)this.contratBox.getConvertedValue();
        this.listener.onPopupClose();
    }

    public Long getModeleContratId() {
        return this.idModeleContrat;
    }
}

