/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.common.contrattelecharger;

import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.service.services.docengagement.DocEngagementGeneralService;
import fr.amapj.service.services.edgenerator.excel.EGBilanCompletCheque;
import fr.amapj.service.services.edgenerator.excel.EGCollecteCheque;
import fr.amapj.service.services.edgenerator.excel.EGUtilisateurContrat;
import fr.amapj.service.services.edgenerator.excel.docengagement.EGBilanDocEngagementSignOnLine;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien.EGFeuilleDistributionAmapien;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.amapien.EGLiasseFeuilleDistributionAmapien;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGFeuilleDistributionProducteur;
import fr.amapj.service.services.edgenerator.excel.feuilledistribution.producteur.EGSyntheseContrat;
import fr.amapj.service.services.edgenerator.pdf.PGEngagement;
import fr.amapj.service.services.edgenerator.zip.ZGAllDocEngagementModeleContrat;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.popup.corepopup.CorePopup;

public class TelechargerContrat {
    public static CorePopup displayPopupTelechargerContrat(Long idModeleContrat, Long idContrat) {
        TelechargerPopup popup = new TelechargerPopup("T\u00e9lecharger ...", 60);
        ModeleContratDTO dto = new GestionContratService().loadModeleContrat(idModeleContrat);
        if (idContrat != null) {
            popup.addGenerator(new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.STD, idModeleContrat, idContrat));
            popup.addGenerator(new DocEngagementGeneralService().getDocumentEngagementForContrat((Long)idContrat).generator);
            popup.addSeparator();
        }
        popup.addGenerator(new EGFeuilleDistributionProducteur(idModeleContrat));
        popup.addGenerator(new EGLiasseFeuilleDistributionAmapien(idModeleContrat));
        popup.addGenerator(new EGSyntheseContrat(idModeleContrat));
        popup.addLabel("");
        if (dto.gestionDocEngagement == GestionDocEngagement.GENERATION_DOCUMENT_SEUL) {
            popup.addGenerator(new PGEngagement(PGEngagement.PGEngagementMode.TOUS_LES_CONTRATS, idModeleContrat, null, null));
            popup.addLabel("");
        }
        if (dto.gestionDocEngagement == GestionDocEngagement.SIGNATURE_EN_LIGNE) {
            popup.addGenerator(new EGBilanDocEngagementSignOnLine(idModeleContrat));
            popup.addGenerator(new ZGAllDocEngagementModeleContrat(idModeleContrat));
            popup.addLabel("");
        }
        if (dto.gestionPaiement == GestionPaiement.GESTION_STANDARD) {
            popup.addGenerator(new EGCollecteCheque(idModeleContrat));
            popup.addGenerator(new EGBilanCompletCheque(idModeleContrat));
            popup.addLabel("");
        }
        popup.addGenerator(new EGUtilisateurContrat(idModeleContrat));
        popup.addLabel("");
        popup.addGenerator(new EGFeuilleDistributionAmapien(EGFeuilleDistributionAmapien.EGMode.UN_VIERGE, idModeleContrat, null));
        if (dto.gestionDocEngagement != GestionDocEngagement.AUCUNE_GESTION) {
            popup.addGenerator(new PGEngagement(PGEngagement.PGEngagementMode.UN_VIERGE, idModeleContrat, null, null));
        }
        return popup;
    }
}

