/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.compte;

import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.moncompte.MonCompteService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import fr.amapj.view.engine.popup.PopupListener;
import fr.amapj.view.engine.popup.formpopup.validator.EmailValidator;
import fr.amapj.view.engine.template.FrontOfficeView;
import fr.amapj.view.engine.tools.InLineFormHelper;
import java.io.Serializable;

public class MonCompteView
extends FrontOfficeView
implements PopupListener {
    private static String TEXTFIELD_COMPTEINPUT = "compteinput";
    private static String PANEL_COMPTEFORM = "compteform";
    UtilisateurDTO u;
    TextField nom;
    TextField prenom;
    TextField mail;
    TextField pwd;
    TextField numTel1;
    TextField numTel2;
    TextField adresse;
    TextField codePostal;
    TextField ville;
    FormLayout form1;
    FormLayout form2;
    FormLayout form3;

    @Override
    public String getMainStyleName() {
        return "moncompte";
    }

    @Override
    public void enter() {
        Panel p0 = new Panel();
        p0.setWidth("100%");
        p0.addStyleName(PANEL_COMPTEFORM);
        VerticalLayout vl1 = new VerticalLayout();
        vl1.setMargin(true);
        p0.setContent((Component)vl1);
        this.addComponent((Component)p0);
        this.form1 = new FormLayout();
        this.form1.setMargin(false);
        this.form1.addStyleName("light");
        vl1.addComponent((Component)this.form1);
        Label section = new Label("Nom et pr\u00e9nom");
        section.addStyleName("h2");
        section.addStyleName("colored");
        this.form1.addComponent((Component)section);
        this.nom = this.addTextField("Votre nom ", this.form1);
        this.prenom = this.addTextField("Votre pr\u00e9nom ", this.form1);
        InLineFormHelper formHelper = new InLineFormHelper("Votre mail", "Modifier votre adresse mail", this, (Button.ClickListener & Serializable)e -> this.handleSaveMail());
        this.mail = this.addTextField("Votre mail", formHelper.getForm());
        formHelper.getValidatorManager().add((AbstractField)this.mail, "Votre mail", "mail", new EmailValidator());
        formHelper.addIn((Layout)vl1);
        formHelper = new InLineFormHelper("Votre mot de passe", "Modifier votre mot de passe", this, (Button.ClickListener & Serializable)e -> this.handleSavePassword());
        this.pwd = this.addTextField("Votre mot de passe", formHelper.getForm());
        formHelper.addIn((Layout)vl1);
        formHelper = new InLineFormHelper("Vos coordonn\u00e9es", "Modifier vos coordonn\u00e9es", this, (Button.ClickListener & Serializable)e -> this.handleSaveChangerCoordonnees());
        this.numTel1 = this.addTextField("Num\u00e9ro de tel 1", formHelper.getForm());
        this.numTel2 = this.addTextField("Num\u00e9ro de tel 2", formHelper.getForm());
        this.adresse = this.addTextField("Adresse", formHelper.getForm());
        this.codePostal = this.addTextField("Code Postal", formHelper.getForm());
        this.ville = this.addTextField("Ville", formHelper.getForm());
        formHelper.addIn((Layout)vl1);
        this.refresh();
    }

    private void handleSaveMail() {
        String newValue = (String)this.mail.getValue();
        new MonCompteService().setNewEmail(this.u.getId(), newValue);
    }

    private void handleSavePassword() {
        String newValue = (String)this.pwd.getValue();
        new PasswordManager().setUserPassword(this.u.id, newValue);
    }

    private void handleSaveChangerCoordonnees() {
        this.u.setNumTel1((String)this.numTel1.getValue());
        this.u.setNumTel2((String)this.numTel2.getValue());
        this.u.setLibAdr1((String)this.adresse.getValue());
        this.u.setCodePostal((String)this.codePostal.getValue());
        this.u.setVille((String)this.ville.getValue());
        new MonCompteService().updateCoordoonees(this.u);
    }

    @Override
    public void onPopupClose() {
        this.refresh();
    }

    private void refresh() {
        this.u = new UtilisateurService().loadUtilisateurDto(SessionManager.getUserId());
        this.setValue(this.nom, this.u.getNom());
        this.setValue(this.prenom, this.u.getPrenom());
        this.setValue(this.mail, this.u.getEmail());
        this.setValue(this.pwd, "***********");
        this.setValue(this.numTel1, this.u.getNumTel1());
        this.setValue(this.numTel2, this.u.getNumTel2());
        this.setValue(this.adresse, this.u.getLibAdr1());
        this.setValue(this.codePostal, this.u.getCodePostal());
        this.setValue(this.ville, this.u.getVille());
    }

    private void setValue(TextField tf, String val) {
        tf.setReadOnly(false);
        tf.setValue(val);
        tf.setReadOnly(true);
    }

    private TextField addTextField(String lib, FormLayout form) {
        TextField name = new TextField(lib);
        name.addStyleName(TEXTFIELD_COMPTEINPUT);
        name.setWidth("100%");
        name.setNullRepresentation("");
        name.setReadOnly(true);
        form.addComponent((Component)name);
        return name;
    }
}

