/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.cotisation.bilan;

import fr.amapj.service.services.edgenerator.excel.EGBilanAdhesion;
import fr.amapj.service.services.edgenerator.pdf.PGBulletinAdhesion;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.cotisation.bilan.PeriodeCotisationEditorPart;
import java.util.List;

public class BilanCotisationView
extends StandardListPart<PeriodeCotisationDTO> {
    public BilanCotisationView() {
        super(PeriodeCotisationDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des p\u00e9riodes d'adh\u00e9sion";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er une p\u00e9riode", ButtonType.ALWAYS, e -> new PeriodeCotisationEditorPart(true, null));
        this.addButton("Modifier une p\u00e9riode", ButtonType.EDIT_MODE, e -> new PeriodeCotisationEditorPart(false, (PeriodeCotisationDTO)e));
        this.addButton("Supprimer une p\u00e9riode", ButtonType.EDIT_MODE, e -> this.handleSupprimer());
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.EDIT_MODE, e -> this.handleTelecharger());
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nom", "Nom de la p\u00e9riode");
        this.addColumn("nbAdhesion", "Nombre d'adh\u00e9rents").right();
        this.addColumnCurrency("mntTotalAdhesion", "Montant total des adh\u00e9sions (en \u20ac)").right();
        this.addColumn("nbPaiementDonnes", "Nb de paiements r\u00e9ceptionn\u00e9s").right();
        this.addColumn("nbPaiementARecuperer", "Nb de paiements \u00e0 r\u00e9cup\u00e9rer").right();
    }

    @Override
    protected List<PeriodeCotisationDTO> getLines() {
        return new GestionCotisationService().getAll();
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nom"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom"};
    }

    private CorePopup handleSupprimer() {
        PeriodeCotisationDTO dto = (PeriodeCotisationDTO)this.getSelectedLine();
        String text = "Etes vous s\u00fbr de vouloir supprimer la p\u00e9riode d'adh\u00e9sion " + dto.nom + " ?";
        return new SuppressionPopup(text, dto.id, e -> new GestionCotisationService().delete((Long)e));
    }

    private CorePopup handleTelecharger() {
        PeriodeCotisationDTO dto = (PeriodeCotisationDTO)this.getSelectedLine();
        boolean hasBulletin = dto.idBulletinAdhesion != null;
        TelechargerPopup popup = new TelechargerPopup("Bilan des adh\u00e9sions");
        popup.addGenerator(new EGBilanAdhesion(dto.id));
        if (hasBulletin) {
            popup.addGenerator(PGBulletinAdhesion.allBulletinPeriode(dto.id));
        }
        return popup;
    }
}

