/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.cotisation.reception;

import com.vaadin.ui.Component;
import fr.amapj.service.services.edgenerator.excel.EGBilanAdhesion;
import fr.amapj.service.services.edgenerator.pdf.PGBulletinAdhesion;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionsService;
import fr.amapj.view.engine.excelgenerator.TelechargerPopup;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.corepopup.CorePopup;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.views.cotisation.PeriodeCotisationSelectorPart;
import fr.amapj.view.views.cotisation.reception.AjouterEnMasseAdhesion;
import fr.amapj.view.views.cotisation.reception.PopupAjoutCotisation;
import fr.amapj.view.views.cotisation.reception.PopupModifCotisation;
import fr.amapj.view.views.cotisation.reception.ReceptionnerEnMasseAdhesion;
import java.util.List;

public class ReceptionCotisationView
extends StandardListPart<PeriodeCotisationUtilisateurDTO> {
    private PeriodeCotisationSelectorPart periodeSelector = new PeriodeCotisationSelectorPart(this);

    public ReceptionCotisationView() {
        super(PeriodeCotisationUtilisateurDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "R\u00e9ception des adh\u00e9sions";
    }

    @Override
    protected void addSelectorComponent() {
        this.addComponent((Component)this.periodeSelector.getChoixPeriodeComponent());
    }

    @Override
    protected void drawButton() {
        this.addButton("Ajouter une adh\u00e9sion", ButtonType.ALWAYS, e -> new PopupAjoutCotisation(this.periodeSelector.getPeriodeId()));
        this.addButton("R\u00e9ceptionner/Modifier une adh\u00e9sion", ButtonType.EDIT_MODE, e -> new PopupModifCotisation((PeriodeCotisationUtilisateurDTO)e));
        this.addButton("Supprimer une adh\u00e9sion", ButtonType.EDIT_MODE, e -> this.handleSupprimer((PeriodeCotisationUtilisateurDTO)e));
        this.addButton("T\u00e9l\u00e9charger", ButtonType.ALWAYS, e -> this.handleTelecharger((PeriodeCotisationUtilisateurDTO)e));
        this.addButton("Ajouter en masse", ButtonType.ALWAYS, e -> new AjouterEnMasseAdhesion(this.periodeSelector.getPeriodeId()));
        this.addButton("R\u00e9ceptionner en masse", ButtonType.ALWAYS, e -> new ReceptionnerEnMasseAdhesion(this.periodeSelector.getPeriodeId()));
        this.addSearchField("Rechercher par nom");
    }

    @Override
    protected void drawTable() {
        this.addColumn("nomUtilisateur", "Nom ");
        this.addColumn("prenomUtilisateur", "Pr\u00e9nom");
        this.addColumnDate("dateAdhesion", "Date de l'adh\u00e9sion");
        this.addColumnDate("dateReceptionCheque", "Date r\u00e9ception ch\u00e9que");
        this.addColumnCurrency("montantAdhesion", "Montant adh\u00e9sion (en \u20ac)").right();
        this.addColumn("etatPaiementAdhesion", "Etat du paiement");
        this.addColumn("typePaiementAdhesion", "Type de paiement");
    }

    @Override
    protected List<PeriodeCotisationUtilisateurDTO> getLines() {
        Long idPeriode = this.periodeSelector.getPeriodeId();
        if (idPeriode == null) {
            return null;
        }
        return new GestionCotisationService().loadBilanAdhesion((Long)idPeriode).utilisateurDTOs;
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"nomUtilisateur", "prenomUtilisateur"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nomUtilisateur", "prenomUtilisateur"};
    }

    private CorePopup handleSupprimer(PeriodeCotisationUtilisateurDTO dto) {
        String text = "Etes vous s\u00fbr de vouloir supprimer l'adh\u00e9sion de " + dto.nomUtilisateur + " " + dto.prenomUtilisateur + " ?";
        SuppressionPopup confirmPopup = new SuppressionPopup(text, dto.id, e -> new MesAdhesionsService().deleteAdhesion((Long)e, true));
        return confirmPopup;
    }

    private TelechargerPopup handleTelecharger(PeriodeCotisationUtilisateurDTO dto) {
        Long idPeriode = this.periodeSelector.getPeriodeId();
        boolean hasBulletin = new GestionCotisationService().load((Long)idPeriode).idBulletinAdhesion != null;
        TelechargerPopup popup = new TelechargerPopup("R\u00e9ception des adh\u00e9sions");
        if (dto != null && hasBulletin) {
            popup.addGenerator(PGBulletinAdhesion.oneBulletinCreated(idPeriode, dto.id));
            popup.addSeparator();
        }
        popup.addGenerator(new EGBilanAdhesion(idPeriode));
        if (hasBulletin) {
            popup.addGenerator(PGBulletinAdhesion.allBulletinPeriode(idPeriode));
        }
        return popup;
    }
}

