/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.editionspe;

import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.etiquette.EtiquetteColJson;
import fr.amapj.model.models.editionspe.etiquette.EtiquetteProducteurJson;
import fr.amapj.service.services.editionspe.EditionSpeDTO;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import java.util.ArrayList;
import java.util.List;

public class EtiquetteProducteurEditorPart
extends WizardFormPopup {
    private EtiquetteProducteurJson etiquetteDTO;
    private boolean create;

    public EtiquetteProducteurEditorPart(boolean create, EditionSpeDTO p) {
        this.create = create;
        this.setWidth(80);
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'une \u00e9tiquette";
            this.etiquetteDTO = new EtiquetteProducteurJson();
        } else {
            this.popupTitle = "Modification d'une \u00e9tiquette";
            this.etiquetteDTO = (EtiquetteProducteurJson)new EditionSpeService().load(p.id);
        }
        this.setModel(this.etiquetteDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldColonnes());
        this.add(() -> this.addFieldMarges());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de l'\u00e9tiquette");
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(EditionSpecifique.class, "nom", this.etiquetteDTO.getId());
        this.addTextField("Nom", "nom", uniq);
        this.addIntegerField("Nb de colonnes", "nbColonne", new IValidator[0]);
        this.addIntegerField("Hauteur d'une ligne (en mm)", "hauteur", new IValidator[0]);
    }

    private void addFieldColonnes() {
        this.setStepTitle("la largeur des colonnes en mm");
        this.initializeLargeur();
        CollectionEditor<EtiquetteColJson> f1 = this.addCollectionEditorField("Liste des largeurs", "largeurColonnes", EtiquetteColJson.class, new IValidator[0]);
        f1.addColumn("nom", "Nom", FieldType.STRING, null);
        f1.addColumn("largeur", "Largeur en mm", FieldType.INTEGER, 70);
        f1.disableAllButtons();
    }

    private void initializeLargeur() {
        int nbCol = this.etiquetteDTO.getNbColonne();
        ArrayList<EtiquetteColJson> res = new ArrayList<EtiquetteColJson>();
        int i = 0;
        while (i < nbCol) {
            EtiquetteColJson dto = this.createEtiquetteColDto(i, this.etiquetteDTO.getLargeurColonnes());
            res.add(dto);
            ++i;
        }
        this.etiquetteDTO.setLargeurColonnes(res);
    }

    private EtiquetteColJson createEtiquetteColDto(int i, List<EtiquetteColJson> largeurColonnes) {
        EtiquetteColJson dto = new EtiquetteColJson();
        dto.setNom("Largeur de la colonne " + (i + 1));
        if (i < largeurColonnes.size()) {
            dto.setLargeur(largeurColonnes.get(i).getLargeur());
        }
        return dto;
    }

    private void addFieldMarges() {
        this.setStepTitle("les marges et les bordures");
        this.addIntegerField("Marge droite (en mm)", "margeDroite", new IValidator[0]);
        this.addIntegerField("Marge gauche (en mm)", "margeGauche", new IValidator[0]);
        this.addIntegerField("Marge en haut (en mm)", "margeHaut", new IValidator[0]);
        this.addIntegerField("Marge en bas (en mm)", "margeBas", new IValidator[0]);
        this.addComboEnumField("Dessiner une bordure", "bordure", new NotNullValidator());
    }

    @Override
    protected void performSauvegarder() {
        new EditionSpeService().update(this.etiquetteDTO, this.create);
    }
}

