/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.editionspe;

import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.editionspe.PageFormat;
import fr.amapj.model.models.editionspe.emargement.FeuilleEmargementJson;
import fr.amapj.model.models.editionspe.emargement.FormatFeuilleEmargement;
import fr.amapj.model.models.editionspe.emargement.ParametresProduitsJson;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.editionspe.EditionSpeDTO;
import fr.amapj.service.services.editionspe.EditionSpeService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import fr.amapj.view.views.searcher.SearcherList;

public class FeuilleEmargementEditorPart
extends WizardFormPopup {
    private FeuilleEmargementJson etiquetteDTO;
    private boolean create;

    public FeuilleEmargementEditorPart(boolean create, EditionSpeDTO p) {
        this.create = create;
        this.setWidth(80);
        if (create) {
            this.popupTitle = "Cr\u00e9ation d'une feuille d'\u00e9margement (mensuelle ou hebdomadaire)";
            this.etiquetteDTO = new FeuilleEmargementJson();
            this.etiquetteDTO.setFormat(FormatFeuilleEmargement.LISTE);
            this.etiquetteDTO.setPageFormat(PageFormat.A4_PAYSAGE);
            this.etiquetteDTO.setLgColNom(40);
            this.etiquetteDTO.setLgColPrenom(30);
            this.etiquetteDTO.setLgColPresence(20);
            this.etiquetteDTO.setLgColnumTel1(30);
            this.etiquetteDTO.setLgColProduits(40);
            this.etiquetteDTO.setNomDuContrat(ChoixOuiNon.OUI);
            this.etiquetteDTO.setNomDuProducteur(ChoixOuiNon.NON);
        } else {
            this.popupTitle = "Modification d'une feuille d'\u00e9margement (mensuelle ou hebdomadaire)";
            this.etiquetteDTO = (FeuilleEmargementJson)new EditionSpeService().load(p.id);
        }
        this.setModel(this.etiquetteDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldGeneral());
        this.add(() -> this.addFieldMarges());
        this.add(() -> this.addFieldLargeur());
        this.add(() -> this.addFieldColonnes());
        this.add(() -> this.addFieldCumulProducteur());
    }

    private void addFieldGeneral() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales de la feuille d'\u00e9margement");
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(EditionSpecifique.class, "nom", this.etiquetteDTO.getId());
        this.addTextField("Nom", "nom", uniq);
        this.addComboEnumField("Type de feuille d'\u00e9margement", "typPlanning", new NotNullValidator());
        this.addComboEnumField("Format de feuille d'\u00e9margement", "format", new NotNullValidator());
        Enum[] enumsToExclude = new Enum[]{RoleList.MASTER};
        this.addComboEnumField("Accessible par ", "accessibleBy", enumsToExclude, new IValidator[]{new NotNullValidator()});
        String str = "La documentation sur les feuilles d'\u00e9margement est disponible ici :<br/><a href=\"http://amapj.fr/docs_utilisateur_liste_emargement.html\" target=\"_blank\">http://amapj.fr/docs_utilisateur_liste_emargement.html</a>";
        this.addHtml(str);
    }

    private void addFieldMarges() {
        this.setStepTitle("les informations de marges et de disposition");
        this.addIntegerField("Marge droite (en mm)", "margeDroite", new IValidator[0]);
        this.addIntegerField("Marge gauche (en mm)", "margeGauche", new IValidator[0]);
        this.addIntegerField("Marge en haut (en mm)", "margeHaut", new IValidator[0]);
        this.addIntegerField("Marge en bas (en mm)", "margeBas", new IValidator[0]);
        this.addComboEnumField("Disposition de la page", "pageFormat", new NotNullValidator());
    }

    private void addFieldLargeur() {
        this.setStepTitle("les informations de largeur des colonnes Nom, pr\u00e9nom, ..");
        this.addIntegerField("Largeur (en mm) de la colonne Nom", "lgColNom", new IValidator[0]);
        this.addIntegerField("Largeur (en mm) de la colonne Pr\u00e9nom", "lgColPrenom", new IValidator[0]);
        this.addIntegerField("Largeur (en mm) de la colonne Pr\u00e9sence", "lgColPresence", new IValidator[0]);
        this.addIntegerField("Largeur (en mm) de la colonne Tel1", "lgColnumTel1", new IValidator[0]);
        this.addIntegerField("Largeur (en mm) de la colonne Tel2", "lgColnumTel2", new IValidator[0]);
        this.addIntegerField("Largeur (en mm) de la colonne Commentaire", "lgColCommentaire", new IValidator[0]);
        this.addIntegerField("Hauteur (en mm) des lignes (ajustement automatique si 0)", "hauteurLigne", new IValidator[0]);
    }

    private void addFieldColonnes() {
        if (this.etiquetteDTO.getFormat() == FormatFeuilleEmargement.GRILLE) {
            this.addFieldColonnesGrille();
        } else {
            this.addFieldColonnesListe();
        }
    }

    private void addFieldColonnesGrille() {
        this.setStepTitle("la description des colonnes (format grille)");
        this.addComboEnumField("Contenu des cellules ", "contenuCellule", new NotNullValidator());
        CollectionEditor<ParametresProduitsJson> f1 = this.addCollectionEditorField("Liste des colonnes", "parametresProduits", ParametresProduitsJson.class, new IValidator[0]);
        f1.addSearcherColumn("idProduit", "Produit", FieldType.SEARCHER, null, SearcherList.PRODUIT_ALL, null);
        f1.addColumn("titreColonne", "Titre de la colonne", FieldType.STRING, "");
        f1.addColumn("largeurColonne", "Largeur en mm", FieldType.INTEGER, 20);
    }

    private void addFieldColonnesListe() {
        this.setStepTitle("la description des colonnes (format liste)");
        this.addIntegerField("Largeur (en mm) de la colonne Produits", "lgColProduits", new IValidator[0]);
        this.addComboEnumField("Imprimer le nom du contrat au dessus des produits", "nomDuContrat", new NotNullValidator());
        this.addComboEnumField("Imprimer le nom du producteur au dessus des produits", "nomDuProducteur", new NotNullValidator());
        this.addComboEnumField("Imprimer la liste des produits", "detailProduits", new NotNullValidator());
    }

    private void addFieldCumulProducteur() {
        if (this.etiquetteDTO.getFormat() == FormatFeuilleEmargement.GRILLE) {
            this.addFieldCumulProducteurGrille();
        } else {
            this.addFieldCumulProducteurListe();
        }
    }

    private void addFieldCumulProducteurGrille() {
        this.setStepTitle("cumul des quantit\u00e9s producteur");
        this.addHtml("Non disponible pour le moment. Appuyer sur continuer");
    }

    private void addFieldCumulProducteurListe() {
        this.setStepTitle("cumul des quantit\u00e9s producteur");
        this.addComboEnumField("Imprimer en tete du document un cumul des quantit\u00e9s livr\u00e9es pour chaque producteur", "listeAffichageCumulProducteur", new NotNullValidator());
    }

    @Override
    protected void performSauvegarder() {
        new EditionSpeService().update(this.etiquetteDTO, this.create);
    }
}

