/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import com.vaadin.data.Property;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Field;
import com.vaadin.ui.PopupDateField;
import com.vaadin.ui.TextField;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.contrat.modele.AffichageMontant;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.JokerMode;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.RetardataireAutorise;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.model.models.contrat.modele.StockGestion;
import fr.amapj.model.models.contrat.modele.StockIdentiqueDate;
import fr.amapj.model.models.contrat.modele.StockMultiContrat;
import fr.amapj.model.models.contrat.modele.StrategiePaiement;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.model.models.param.paramecran.PEGestionContratsVierges;
import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.DatePaiementModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ExtPModeleContratService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.producteur.ProducteurService;
import fr.amapj.service.services.produit.ProduitService;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.fieldlink.FieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionSizeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;
import fr.amapj.view.engine.popup.formpopup.validator.DateRangeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.IntegerRangeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.engine.popup.formpopup.validator.StringLengthValidator;
import fr.amapj.view.engine.popup.formpopup.validator.UniqueInDatabaseValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ValidatorHolder;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.gestioncontrat.editorpart.FrequenceLivraison;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratDateUtils;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratPaiementUtils;
import fr.amapj.view.views.searcher.SDProduit;
import fr.amapj.view.views.searcher.SearcherList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GestionContratEditorPart
extends WizardFormPopup {
    private static final Logger logger = LogManager.getLogger();
    protected ModeleContratDTO modeleContrat;
    private boolean creerAPartirDeMode;
    private Long idCreerAPartir;
    private Searcher prod;
    private List<Producteur> allowedProducteurs;
    private PEGestionContratsVierges peEcran = (PEGestionContratsVierges)new ParametresService().loadParamEcran(MenuList.GESTION_CONTRAT);
    private List<Field<?>> paiementComponents;
    protected ComboBox boxPaiement;

    @Override
    protected void configure() {
        ParametresDTO param = new ParametresService().getParametres();
        this.add(() -> this.drawInfoGenerales(), () -> this.checkInfoGenerales());
        this.add(param.etatGestionCotisation == EtatModule.ACTIF, () -> this.drawAccess());
        this.add(() -> this.drawDateLivraison(), () -> this.checkDateLivraison());
        this.add(() -> this.drawFinInscription(true), () -> this.checkJoker());
        this.add(() -> this.drawChoixProduits());
        this.add(param.etatGestionStock == EtatModule.ACTIF, () -> this.drawGestionStockGeneral());
        this.add(() -> this.drawTypePaiement(null), () -> this.checkTypePaiement());
        this.add(() -> this.drawDetailPaiement(true));
        this.add(() -> this.drawSignatureContrat());
    }

    public GestionContratEditorPart() {
    }

    public GestionContratEditorPart(Long id, List<Producteur> allowedProducteurs) {
        this();
        this.allowedProducteurs = allowedProducteurs;
        this.setWidth(80);
        this.popupTitle = "Cr\u00e9ation d'un contrat";
        if (id == null) {
            this.modeleContrat = new ModeleContratDTO();
            this.modeleContrat.frequence = FrequenceLivraison.UNE_FOIS_PAR_SEMAINE;
            this.modeleContrat.gestionPaiement = GestionPaiement.NON_GERE;
            this.modeleContrat.affichageMontant = AffichageMontant.MONTANT_TOTAL;
            this.modeleContrat.nature = NatureContrat.LIBRE;
            this.modeleContrat.typJoker = TypJoker.SANS_JOKER;
            this.modeleContrat.jokerMode = JokerMode.INSCRIPTION;
            this.modeleContrat.stockGestion = StockGestion.NON;
            this.modeleContrat.gestionDocEngagement = GestionDocEngagement.AUCUNE_GESTION;
            this.creerAPartirDeMode = false;
        } else {
            this.modeleContrat = new GestionContratService().loadModeleContrat(id);
            this.modeleContrat.nom = String.valueOf(this.modeleContrat.nom) + "(Copie)";
            this.modeleContrat.id = null;
            this.modeleContrat.dateLivs.clear();
            this.modeleContrat.datePaiements.clear();
            this.creerAPartirDeMode = true;
            this.idCreerAPartir = id;
        }
        this.setModel(this.modeleContrat);
    }

    private void drawInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales");
        StringLengthValidator len_1_100 = new StringLengthValidator(1, 100);
        StringLengthValidator len_1_255 = new StringLengthValidator(1, 255);
        UniqueInDatabaseValidator uniq = new UniqueInDatabaseValidator(ModeleContrat.class, "nom", null);
        NotNullValidator notNull = new NotNullValidator();
        ProducteurAvecProduitValidator prodValidator = new ProducteurAvecProduitValidator();
        this.addTextField("Nom du contrat", "nom", len_1_100, uniq);
        this.addTextField("Description du contrat", "description", len_1_255);
        this.addComboEnumField("Nature du contrat", "nature", notNull);
        this.prod = this.addSearcher("Producteur", "producteur", SearcherList.PRODUCTEUR, this.allowedProducteurs, notNull, prodValidator);
        if (this.creerAPartirDeMode) {
            this.prod.setEnabled(false);
        }
        this.addComboEnumField("Fr\u00e9quence des livraisons", "frequence", notNull);
    }

    protected void drawAccess() {
        this.setStepTitle("les conditions d'acc\u00e8s \u00e0 ce contrat");
        IValidator[] validators = new IValidator[]{};
        if (this.peEcran.periodeCotisationObligatoire == ChoixOuiNon.OUI) {
            validators = new IValidator[]{new NotNullValidator()};
        }
        this.addSearcher("Pour pouvoir souscrire \u00e0 ce contrat, l'amapien doit \u00eatre inscrit sur la p\u00e9riode d'adh\u00e9sion :", "idPeriodeCotisation", SearcherList.PERIODE_COTISATION, null, validators);
    }

    private String checkInfoGenerales() {
        if (this.modeleContrat.nature == NatureContrat.CARTE_PREPAYEE && this.modeleContrat.frequence == FrequenceLivraison.UNE_SEULE_LIVRAISON) {
            return "Il n'est pas possible de faire un contrat Carte pr\u00e9pay\u00e9e avec une seule date de livraison";
        }
        return null;
    }

    private void drawDateLivraison() {
        this.setStepTitle("les dates de livraison");
        NotNullValidator notNull = new NotNullValidator();
        if (this.modeleContrat.frequence == FrequenceLivraison.UNE_SEULE_LIVRAISON) {
            this.addDateField("Date de la livraison", "dateDebut", notNull);
        } else if (this.modeleContrat.frequence == FrequenceLivraison.AUTRE) {
            CollectionSizeValidator size = new CollectionSizeValidator(1, null);
            CollectionNoDuplicates<DateModeleContratDTO> noDuplicates = new CollectionNoDuplicates<DateModeleContratDTO>(e -> e.dateLiv);
            this.addCollectionEditorField("Liste des dates", "dateLivs", DateModeleContratDTO.class, size, noDuplicates);
            this.addColumn("dateLiv", "Date", FieldType.DATE, null, new ColumnNotNull<DateModeleContratDTO>(e -> e.dateLiv));
        } else {
            this.addDateField("Date de la premi\u00e8re livraison", "dateDebut", notNull);
            this.addDateField("Date de la derni\u00e8re livraison", "dateFin", notNull);
        }
    }

    private String checkDateLivraison() {
        String check = this.performCheckDateLivraison();
        if (check != null) {
            return check;
        }
        new GestionContratDateUtils().computeDateLivraison(this.modeleContrat);
        return null;
    }

    private String performCheckDateLivraison() {
        if (this.modeleContrat.frequence == FrequenceLivraison.UNE_SEULE_LIVRAISON) {
            return null;
        }
        if (this.modeleContrat.frequence == FrequenceLivraison.AUTRE) {
            return null;
        }
        if (this.modeleContrat.dateDebut.after(this.modeleContrat.dateFin)) {
            return "La date de d\u00e9but doit \u00eatre avant la date de fin ";
        }
        return null;
    }

    protected void drawFinInscription(boolean blocJoker) {
        if (this.modeleContrat.nature == NatureContrat.CARTE_PREPAYEE) {
            this.modeleContrat.dateFinInscription = null;
            this.modeleContrat.retardataireAutorise = RetardataireAutorise.NON;
            this.setStepTitle("Contrat Carte pr\u00e9pay\u00e9e - D\u00e9lai pour modification du contrat");
            this.addIntegerField("D\u00e9lai en jour pour modification du contrat avant livraison", "cartePrepayeeDelai", new IValidator[0]);
            this.addHtml("Votre contrat est de type Carte prepay\u00e9e, c'est \u00e0 dire que l'adh\u00e9rent peut modifier le contrat m\u00eame apr\u00e8s le d\u00e9but des livraisons.<br/>Ce champ vous permet d'indiquer le d\u00e9lai entre la derni\u00e8re modification possible et la livraison<br/>Par exemple, si les livraisons sont le samedi et si vous mettez 2 dans ce champ, alors l'adh\u00e9rent pourra alors modifier son contrat pour cette livraison jusqu'au mercredi soir minuit");
        } else {
            this.setStepTitle("la date de fin des inscriptions");
            NotNullValidator notNull = new NotNullValidator();
            Date firstLiv = this.modeleContrat.dateLivs.get((int)0).dateLiv;
            DateRangeValidator dateRange = new DateRangeValidator(null, firstLiv);
            String helpText = "Cette date de fin des inscriptions doit obligatoirement \u00eatre avant la date de la premi\u00e8re livraison (c'est \u00e0 dire avant le " + FormatUtils.getStdDate().format(firstLiv) + ")<br/><br/>";
            this.addDateField("Date de fin des inscriptions", "dateFinInscription", helpText, notNull, dateRange);
            this.addBr();
            this.addBlocRetardataire();
            if (blocJoker && this.modeleContrat.nature == NatureContrat.ABONNEMENT) {
                this.addBr();
                this.addBlocGestionJoker();
            }
        }
    }

    protected void addBlocRetardataire() {
        if (this.modeleContrat.nature == NatureContrat.CARTE_PREPAYEE) {
            return;
        }
        if (this.modeleContrat.dateLivs.size() == 1) {
            this.modeleContrat.retardataireAutorise = RetardataireAutorise.NON;
            String helpText = "Sur ce contrat, il n'est pas possible d'activer l'inscription en tant que retardataire car il y a une seule date de livraison";
            this.addComboEnumField("L'inscription en tant que retardataire est autoris\u00e9e", "retardataireAutorise", helpText).setEnabled(false);
            return;
        }
        switch (this.peEcran.gestionRetardataire) {
            case TOUJOURS_NON_AUTORISE: {
                this.modeleContrat.retardataireAutorise = RetardataireAutorise.NON;
                String helpText1 = PEGestionContratsVierges.GestionRetardataire.MetaData.helpToujoursNonAutorise;
                this.addComboEnumField("L'inscription en tant que retardataire est autoris\u00e9e", "retardataireAutorise", helpText1).setEnabled(false);
                return;
            }
            case LIBRE_CHOIX: {
                this.addComboEnumField("L'inscription en tant que retardataire est autoris\u00e9e", "retardataireAutorise", new NotNullValidator());
                return;
            }
            case TOUJOURS_AUTORISE: {
                this.modeleContrat.retardataireAutorise = RetardataireAutorise.OUI;
                String helpText2 = PEGestionContratsVierges.GestionRetardataire.MetaData.helpToujoursAutorise;
                this.addComboEnumField("L'inscription en tant que retardataire est autoris\u00e9e", "retardataireAutorise", helpText2).setEnabled(false);
                return;
            }
        }
        throw new AmapjRuntimeException();
    }

    protected void addBlocGestionJoker() {
        if (this.peEcran.gestionJoker == PEGestionContratsVierges.GestionJoker.TOUJOURS_NON) {
            this.modeleContrat.typJoker = TypJoker.SANS_JOKER;
            this.addComboEnumField("Activer la gestion des jokers", "typJoker", PEGestionContratsVierges.GestionJoker.MetaData.helpToujoursNon).setEnabled(false);
            return;
        }
        Enum[] enumsToExcludes = this.computeEnumToExcludeJoker(this.peEcran.gestionJoker);
        int delai = new ProducteurService().getDelaiNotification(this.modeleContrat.producteur);
        ComboBox b1 = this.addComboEnumField("Activer la gestion des jokers", "typJoker", enumsToExcludes, new IValidator[]{new NotNullValidator()});
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{TypJoker.JOKER_ABSENCE, TypJoker.JOKER_REPORT}), b1, true);
        f1.addField(this.addIntegerField("Nombre minimum de reports ou absences autoris\u00e9s pour ce contrat", "jokerNbMin", new IntegerRangeValidator(0, null)), "0", "0");
        f1.addField(this.addIntegerField("Nombre maximum de reports ou absences autoris\u00e9s pour ce contrat", "jokerNbMax", new IntegerRangeValidator(0, null)), "1", "0");
        ComboBox b2 = this.addComboEnumField("Choix des dates de jokers", "jokerMode", f1.getValidator());
        FieldLink f2 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{JokerMode.LIBRE}), b2, true);
        f1.addField(f2, JokerMode.INSCRIPTION, JokerMode.INSCRIPTION);
        f2.addField(this.addIntegerField("D\u00e9lai de pr\u00e9venance (en jours) pour modification des dates jokers", "jokerDelai", TypJoker.helpDelai, new IValidator[0]), "" + delai, "0");
        f1.doLink();
        this.addHelpButton("Aide sur les jokers", TypJoker.helpGeneral);
    }

    private TypJoker[] computeEnumToExcludeJoker(PEGestionContratsVierges.GestionJoker gestionJoker) {
        switch (gestionJoker) {
            case MODE_ABSENCE: {
                return new TypJoker[]{TypJoker.JOKER_REPORT};
            }
            case MODE_REPORT: {
                return new TypJoker[]{TypJoker.JOKER_ABSENCE};
            }
            case TOUT_POSSIBLE: {
                return new TypJoker[0];
            }
        }
        throw new AmapjRuntimeException();
    }

    protected String checkJoker() {
        int delai;
        if (this.modeleContrat.nature != NatureContrat.ABONNEMENT) {
            return null;
        }
        if (this.modeleContrat.typJoker == TypJoker.SANS_JOKER) {
            return null;
        }
        if (this.modeleContrat.jokerNbMin > this.modeleContrat.jokerNbMax) {
            return "Le nombre de joker minimum ne peut pas \u00eatre sup\u00e9rieur au nombre de joker maximum";
        }
        if (this.modeleContrat.jokerNbMax < 1) {
            return "Le nombre de joker maximum doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0 1";
        }
        if (this.modeleContrat.jokerMode == JokerMode.LIBRE && this.modeleContrat.jokerDelai < (delai = new ProducteurService().getDelaiNotification(this.modeleContrat.producteur))) {
            return "Le d\u00e9lai de pr\u00e9venance est trop court.<br/>Dans la fiche producteur, il est indiqu\u00e9 que celui ci recoit par mail les feuilles de distribution " + delai + " jours avant la livraison<br/>" + "Par cons\u00e9quent, vous ne pouvez pas autoriser la modification des jokers " + this.modeleContrat.jokerDelai + " jours avant la livraison<br/>";
        }
        return null;
    }

    private void drawChoixProduits() {
        Long idProducteur = (Long)this.prod.getConvertedValue();
        if (this.modeleContrat.produits.size() == 0 && idProducteur != null) {
            this.modeleContrat.produits.addAll(new GestionContratService().getInfoProduitModeleContrat(idProducteur));
        }
        this.setStepTitle("la liste des produits et des prix");
        CollectionSizeValidator size = new CollectionSizeValidator(1, null);
        CollectionNoDuplicates<LigneContratDTO> noDuplicates = new CollectionNoDuplicates<LigneContratDTO>(e -> e.produitId, e -> new ProduitService().prettyString(e.produitId));
        this.addCollectionEditorField("Produits", "produits", LigneContratDTO.class, size, noDuplicates);
        this.addColumnSearcher("produitId", "Nom du produit", FieldType.SEARCHER, null, new SDProduit(this.prod), this.prod, new ColumnNotNull<LigneContratDTO>(e -> e.produitId));
        this.addColumn("prix", "Prix du produit", FieldType.CURRENCY, null, new ColumnNotNull<LigneContratDTO>(e -> e.prix));
    }

    protected void drawGestionStockGeneral() {
        this.setStepTitle("la gestion des limites en quantit\u00e9 - informations g\u00e9n\u00e9rales ");
        ComboBox b1 = this.addComboEnumField("Activer la gestion des limites en quantit\u00e9 pour ce contrat", "stockGestion", new NotNullValidator());
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{StockGestion.OUI}), b1, true);
        f1.addField(this.addComboEnumField("Le producteur fournit les m\u00eames quantit\u00e9s pour toutes les dates de livraison", "stockIdentiqueDate", f1.getValidator()), StockIdentiqueDate.OUI, null);
        f1.addField(this.addComboEnumField("Les quantit\u00e9s limites s'appliquent sur plusieurs contrats en m\u00eame temps", "stockMultiContrat", f1.getValidator()), StockMultiContrat.NON, null);
        f1.addComponent((AbstractComponent)this.addHtml("Quand vous aurez valid\u00e9 votre contrat, vous pourrez saisir les quantit\u00e9s limites en cliquant sur le bouton Stock de l'\u00e9cran REFERENT / Gestion des contrats vierges"));
        f1.doLink();
    }

    protected void drawTypePaiement(StrategiePaiement[] enumsToExcludes) {
        this.setStepTitle("gen\u00e9ralit\u00e9s sur le paiement");
        NotNullValidator notNull = new NotNullValidator();
        this.boxPaiement = this.addComboEnumField("Mode de gestion des paiements", "strategiePaiement", enumsToExcludes, new IValidator[]{notNull});
        this.boxPaiement.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.paiementChangeListener());
        this.boxPaiement.setWidth("500px");
        this.paiementComponents = new ArrayList();
        this.paiementChangeListener();
    }

    private void paiementChangeListener() {
        this.paiementComponents.forEach(e -> this.suppressElement((Field<?>)e));
        this.paiementComponents.clear();
        StrategiePaiement st = (StrategiePaiement)((Object)this.boxPaiement.getValue());
        if (st == null) {
            return;
        }
        switch (st) {
            case NON_GERE: 
            case UN_PAIEMENT_PAR_LIVRAISON: {
                break;
            }
            case UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ERE_LIVRAISON: 
            case UN_CHEQUE_PAR_MOIS_LISSE_NON_MODIFIABLE_1ERE_LIVRAISON: 
            case UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ER_MOIS: {
                this.paiementComponents.add((Field<?>)this.addCurrencyField("Montant minimum des ch\u00e8ques", "montantChequeMiniCalculProposition", false));
                break;
            }
            case PLUS_DE_CHOIX: {
                ComboBox c = this.addComboEnumField("Mode de calcul de la proposition de paiement", "saisiePaiementProposition", new NotNullValidator());
                this.paiementComponents.add((Field<?>)c);
                FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{SaisiePaiementProposition.PAYE_AVANCE_ARRONDI, SaisiePaiementProposition.REPARTI_ARRONDI}), c);
                c = this.addCurrencyField("Montant minimum des ch\u00e8ques", "montantChequeMiniCalculProposition", false);
                this.paiementComponents.add((Field<?>)c);
                f1.addField((AbstractField)c);
                c = this.addComboEnumField("La proposition de paiement est elle modifiable ? ", "saisiePaiementModifiable", new NotNullValidator());
                this.paiementComponents.add((Field<?>)c);
                c = this.addComboEnumField("Mode de calcul des dates de paiements ", "saisiePaiementCalculDate", new NotNullValidator());
                this.paiementComponents.add((Field<?>)c);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    protected String checkTypePaiement() {
        new GestionContratPaiementUtils().fillFieldPaiementFromStrategie(this.modeleContrat);
        new GestionContratDateUtils().computeDatePaiement(this.modeleContrat);
        return null;
    }

    protected void drawDetailPaiement(boolean activeDates) {
        this.setStepTitle("les informations compl\u00e9mentaires sur le paiement");
        StringLengthValidator len_0_2048 = new StringLengthValidator(0, 2048);
        StringLengthValidator len_0_255 = new StringLengthValidator(0, 255);
        NotNullValidator notNull = new NotNullValidator();
        if (this.modeleContrat.gestionPaiement == GestionPaiement.GESTION_STANDARD) {
            this.modeleContrat.affichageMontant = null;
            this.addTextField("Ordre du ch\u00e8que", "libCheque", len_0_255);
            PopupDateField p = this.addDateField("Date limite de remise des ch\u00e8ques", "dateRemiseCheque", notNull);
            Date firstPaiement = this.computeDateRemiseCheque();
            p.setValue((Object)firstPaiement);
            if (activeDates) {
                CollectionSizeValidator size = new CollectionSizeValidator(1, null);
                CollectionNoDuplicates<DatePaiementModeleContratDTO> noDuplicates = new CollectionNoDuplicates<DatePaiementModeleContratDTO>(e -> e.datePaiement);
                this.addCollectionEditorField("Liste des dates de paiement", "datePaiements", DatePaiementModeleContratDTO.class, size, noDuplicates);
                this.addColumn("datePaiement", "Date", FieldType.DATE, null, new ColumnNotNull<DatePaiementModeleContratDTO>(e -> e.datePaiement));
            }
        } else {
            if (this.modeleContrat.id == null && this.modeleContrat.nature == NatureContrat.CARTE_PREPAYEE) {
                this.modeleContrat.affichageMontant = AffichageMontant.MONTANT_PROCHAINE_LIVRAISON;
            }
            this.addComboEnumField("Montant affich\u00e9 dans la fen\u00eatre de paiement", "affichageMontant", notNull);
            TextField f = this.addTextField("Texte affich\u00e9 dans la fen\u00eatre paiement", "textPaiement", len_0_2048);
            f.setMaxLength(2048);
            f.setHeight(5.0f, Sizeable.Unit.CM);
        }
    }

    private Date computeDateRemiseCheque() {
        if (this.modeleContrat.datePaiements.size() == 0) {
            return null;
        }
        return DateUtils.addDays(this.modeleContrat.datePaiements.get((int)0).datePaiement, -10);
    }

    protected void drawSignatureContrat() {
        this.setStepTitle("la gestion des documents d'engagement et leurs signatures");
        ComboBox b1 = this.addComboEnumField("Gestion des documents d'engagement", "gestionDocEngagement", new NotNullValidator());
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{GestionDocEngagement.SIGNATURE_EN_LIGNE, GestionDocEngagement.GENERATION_DOCUMENT_SEUL}), b1, true);
        f1.addField(this.addSearcher("Document d'engagement (\u00e0 signer) ", "idEngagement", SearcherList.ENGAGEMENT, null, f1.getValidator()));
        f1.doLink();
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        Long idNewContrat = new GestionContratService().saveNewModeleContrat(this.modeleContrat);
        if (this.idCreerAPartir != null) {
            new ExtPModeleContratService().copyExtendedParam(this.idCreerAPartir, idNewContrat);
        }
    }

    public class ProducteurAvecProduitValidator
    implements IValidator {
        @Override
        public void performValidate(Object value, ValidatorHolder a) {
            List<LigneContratDTO> ligs;
            Long p = (Long)value;
            if (p != null && (ligs = new GestionContratService().getInfoProduitModeleContrat(p)).size() == 0) {
                a.addMessage("Ce producteur ne poss\u00e9de pas de produits.");
                a.addMessage("Pour pouvoir cr\u00e9er un contrat pour ce producteur");
                a.addMessage("Vous devez d'abord aller dans le menu \"Gestion des produits\",");
                a.addMessage("et indiquer la liste des produits faits par ce producteur.");
            }
        }

        @Override
        public boolean canCheckOnFly() {
            return true;
        }

        @Override
        public AbstractField[] revalidateOnChangeOf() {
            return null;
        }
    }
}

