/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.extendparam.MiseEnFormeGraphique;
import fr.amapj.service.services.gestioncontrat.ExtPModeleContratService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.fieldlink.ClassicFieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;

public class MiseEnFormeModeleContratEditorPart
extends WizardFormPopup {
    private MiseEnFormeGraphique miseEnForme;
    private Long idModeleContrat;
    private ModeleContratDTO modelecontratDto;

    public MiseEnFormeModeleContratEditorPart(Long idModeleContrat) {
        this.idModeleContrat = idModeleContrat;
        this.setWidth(80);
        this.popupTitle = "Mise en forme d'un mod\u00e8le de contrat";
        this.modelecontratDto = new GestionContratService().loadModeleContrat(idModeleContrat);
        this.miseEnForme = new ExtPModeleContratService().loadMiseEnFormeGraphique(idModeleContrat);
        this.setModel(this.miseEnForme);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldSaisieQuantite());
        this.add(() -> this.addFieldPaiement());
    }

    private void addFieldSaisieQuantite() {
        this.setStepTitle("Mise en forme du popup de saisie des quantit\u00e9s");
        if (this.modelecontratDto.nature == NatureContrat.ABONNEMENT) {
            this.addHtml("Vous ne pouvez pas modifier la pr\u00e9sentation des contrats ayant pour nature ABONNEMENT");
        } else {
            this.addComboEnumField("Pr\u00e9sentation pour la saisie des quantit\u00e9s", "styleSaisieQteContrat", new NotNullValidator());
        }
    }

    private void addFieldPaiement() {
        this.setStepTitle("Mise en forme du popup de paiement");
        if (this.modelecontratDto.gestionPaiement == GestionPaiement.NON_GERE) {
            this.addHtml("Pas de parametrage possible en mode PAS DE GESTION DES PAIEMENTS");
        } else {
            this.addBlocTexteParametrable("Ch\u00e8ques \u00e0 remettre \u00e0 .... suivi du nom d'un des r\u00e9f\u00e9rents", "paiementStdLib1");
            this.addBlocTexteParametrable("Une proposition de paiement a \u00e9t\u00e9 calcul\u00e9e et est affich\u00e9e ...", "paiementStdLib2");
        }
    }

    private void addBlocTexteParametrable(String lib, String field) {
        this.addHtml("Texte \"" + lib + "\"");
        ClassicFieldLink f1 = new ClassicFieldLink();
        f1.box = this.addComboEnumField("Modifier ce texte", String.valueOf(field) + "Modifier", new NotNullValidator());
        f1.ckEditor = this.addCKEditorFieldForLabel("Remplacer ce texte par", field);
        f1.doLink();
    }

    @Override
    protected void performSauvegarder() {
        new ExtPModeleContratService().saveMiseEnFormeGraphique(this.idModeleContrat, this.miseEnForme);
    }
}

