/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.TextField;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.DatePaiementModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.searcher.Searcher;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratPaiementUtils;
import fr.amapj.view.views.searcher.SDProduit;
import fr.amapj.view.views.searcher.SearcherList;

public class ModeleContratVisualiserPart
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;
    private Searcher prod;

    @Override
    protected void configure() {
        this.add(() -> this.drawInfoGenerales());
        this.add(() -> this.drawAccess());
        this.add(() -> this.drawDateLivraison());
        this.add(() -> this.drawFinInscription());
        this.add(() -> this.drawChoixProduits());
        this.add(() -> this.drawTypePaiement());
        this.add(() -> this.drawDetailPaiement());
        this.add(() -> this.drawSignatureContrat());
    }

    public ModeleContratVisualiserPart(Long id) {
        this.setWidth(80);
        this.popupTitle = "Visualisation d'un mod\u00e8le de contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
        this.saveButtonTitle = "OK";
    }

    private void drawInfoGenerales() {
        this.setStepTitle("les informations g\u00e9n\u00e9rales");
        this.addTextField("Nom du contrat", "nom", new IValidator[0]);
        this.addTextField("Description du contrat", "description", new IValidator[0]);
        this.addComboEnumField("Nature du contrat", "nature", new IValidator[0]);
        this.prod = this.addSearcher("Producteur", "producteur", SearcherList.PRODUCTEUR, null, new IValidator[0]);
        this.addComboEnumField("Fr\u00e9quence des livraisons", "frequence", new IValidator[0]);
        this.setReadOnlyAll();
    }

    protected void drawAccess() {
        this.setStepTitle("les conditions d'acc\u00e8s \u00e0 ce contrat");
        ParametresDTO param = new ParametresService().getParametres();
        if (param.etatGestionCotisation == EtatModule.INACTIF) {
            this.addHtml("Ce contrat sera accessible par tous les amapiens. Vous pouvez cliquer sur Etape suivante");
            return;
        }
        this.addSearcher("Pour pouvoir souscrire \u00e0 ce contrat, l'amapien doit \u00eatre inscrit sur la p\u00e9riode d'adh\u00e9sion :", "idPeriodeCotisation", SearcherList.PERIODE_COTISATION, null, new IValidator[0]);
        this.setReadOnlyAll();
    }

    private void drawDateLivraison() {
        this.setStepTitle("les dates de livraison");
        this.addCollectionEditorField("Liste des dates", "dateLivs", DateModeleContratDTO.class, new IValidator[0]);
        this.addColumn("dateLiv", "Date", FieldType.DATE, null, new IValidator[0]);
        this.setReadOnlyAll();
    }

    protected void drawFinInscription() {
        if (this.modeleContrat.nature == NatureContrat.CARTE_PREPAYEE) {
            this.setStepTitle("Contrat Carte pr\u00e9pay\u00e9e - D\u00e9lai pour modification du contrat");
            this.addIntegerField("D\u00e9lai en jour pour modification du contrat avant livraison", "cartePrepayeeDelai", new IValidator[0]);
        } else {
            this.setStepTitle("la date de fin des inscriptions");
            this.addDateField("Date de fin des inscriptions", "dateFinInscription", new IValidator[0]);
            this.addComboEnumField("L'inscription en tant que retardataire est autoris\u00e9", "retardataireAutorise", new IValidator[0]);
            if (this.modeleContrat.nature == NatureContrat.ABONNEMENT) {
                this.addHtml("<br/>");
                this.addBlocGestionJoker();
            }
        }
        this.setReadOnlyAll();
    }

    protected void addBlocGestionJoker() {
        this.addComboEnumField("Activer la gestion des jokers", "typJoker", new IValidator[0]);
        if (this.modeleContrat.typJoker != TypJoker.SANS_JOKER) {
            this.addIntegerField("Nombre minimum de reports ou absences autoris\u00e9s pour ce contrat", "jokerNbMin", new IValidator[0]);
            this.addIntegerField("Nombre maximum de reports ou absences autoris\u00e9s pour ce contrat", "jokerNbMax", new IValidator[0]);
            this.addComboEnumField("Choix des dates de jokers", "jokerMode", new IValidator[0]);
            this.addIntegerField("D\u00e9lai de pr\u00e9venance (en jours) pour modifiation des dates jokers", "jokerDelai", new IValidator[0]);
        }
        this.setReadOnlyAll();
    }

    private void drawChoixProduits() {
        this.setStepTitle("la liste des produits et des prix");
        this.addCollectionEditorField("Produits", "produits", LigneContratDTO.class, new IValidator[0]);
        this.addColumnSearcher("produitId", "Nom du produit", FieldType.SEARCHER, null, new SDProduit(this.prod), this.prod, new IValidator[0]);
        this.addColumn("prix", "Prix du produit", FieldType.CURRENCY, null, new IValidator[0]);
        this.setReadOnlyAll();
    }

    protected void drawTypePaiement() {
        new GestionContratPaiementUtils().checkAndUpdateStrategieAndSaisiePaiementCalculDate(this.modeleContrat);
        this.setStepTitle("gen\u00e9ralit\u00e9s sur le paiement");
        this.addComboEnumField("Mode de gestion des paiements", "strategiePaiement", new IValidator[0]).setWidth("500px");
        switch (this.modeleContrat.strategiePaiement) {
            case NON_GERE: 
            case UN_PAIEMENT_PAR_LIVRAISON: {
                break;
            }
            case UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ERE_LIVRAISON: 
            case UN_CHEQUE_PAR_MOIS_LISSE_NON_MODIFIABLE_1ERE_LIVRAISON: 
            case UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ER_MOIS: {
                this.addCurrencyField("Montant minimum des ch\u00e8ques", "montantChequeMiniCalculProposition", false);
                break;
            }
            case PLUS_DE_CHOIX: {
                this.addComboEnumField("Mode de calcul de la proposition de paiement", "saisiePaiementProposition", new IValidator[0]);
                this.addCurrencyField("Montant minimum des ch\u00e8ques", "montantChequeMiniCalculProposition", false);
                this.addComboEnumField("La proposition de paiement est elle modifiable ? ", "saisiePaiementModifiable", new IValidator[0]);
                this.addComboEnumField("Mode de calcul des dates de paiements ", "saisiePaiementCalculDate", new IValidator[0]);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
        this.setReadOnlyAll();
    }

    private void drawDetailPaiement() {
        this.setStepTitle("les informations sur le paiement");
        if (this.modeleContrat.gestionPaiement == GestionPaiement.GESTION_STANDARD) {
            this.addTextField("Ordre du ch\u00e8que", "libCheque", new IValidator[0]);
            this.addDateField("Date limite de remise des ch\u00e8ques", "dateRemiseCheque", new IValidator[0]);
            this.addCollectionEditorField("Liste des dates de paiements", "datePaiements", DatePaiementModeleContratDTO.class, new IValidator[0]);
            this.addColumn("datePaiement", "Date", FieldType.DATE, null, new IValidator[0]);
        } else {
            TextField f = this.addTextField("Texte affich\u00e9 dans la fen\u00eatre paiement", "textPaiement", new IValidator[0]);
            f.setMaxLength(2048);
            f.setHeight(5.0f, Sizeable.Unit.CM);
        }
        this.setReadOnlyAll();
    }

    private void drawSignatureContrat() {
        this.setStepTitle("la gestion des documents d'engagement et leurs signatures");
        this.addComboEnumField("Gestion des documents d'engagement", "gestionDocEngagement", new IValidator[0]);
        if (this.modeleContrat.idEngagement != null) {
            this.addSearcher("Document d'engagement (\u00e0 signer) ", "idEngagement", SearcherList.ENGAGEMENT, null, new IValidator[0]);
        }
        this.setReadOnlyAll();
    }

    @Override
    protected void performSauvegarder() {
    }
}

