/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart;

import fr.amapj.service.services.gestioncontrat.DateModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionSizeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.views.gestioncontrat.editorpart.FrequenceLivraison;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratDateUtils;

public class ModifDateContratEditorPart
extends WizardFormPopup {
    private ModeleContratDTO modeleContrat;

    public ModifDateContratEditorPart(Long id) {
        this.setWidth(80);
        this.popupTitle = "Modification des dates de livraison d'un contrat";
        this.modeleContrat = new GestionContratService().loadModeleContrat(id);
        this.setModel(this.modeleContrat);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldChoixFrequence());
        this.add(() -> this.addFieldDateLivraison(), () -> this.checkDateLivraison());
    }

    private void addFieldChoixFrequence() {
        this.setStepTitle("frequence des livraisons");
        this.addComboEnumField("Fr\u00e9quence des livraisons", "frequence", new IValidator[0]);
        this.addHtml("Nota : si vous souhaitez modifier uniquement une date ou deux dans la liste et ne pas tout recalculer,<br/>merci de choisir \"Autre ...\" dans la liste d\u00e9roulante ci dessus.");
    }

    private void addFieldDateLivraison() {
        this.setStepTitle("les dates de livraison");
        if (this.modeleContrat.frequence == FrequenceLivraison.UNE_SEULE_LIVRAISON) {
            this.addDateField("Date de la livraison", "dateDebut", new IValidator[0]);
        } else if (this.modeleContrat.frequence == FrequenceLivraison.AUTRE) {
            CollectionSizeValidator size = new CollectionSizeValidator(1, null);
            CollectionNoDuplicates<DateModeleContratDTO> noDuplicates = new CollectionNoDuplicates<DateModeleContratDTO>(e -> e.dateLiv);
            this.addCollectionEditorField("Liste des dates", "dateLivs", DateModeleContratDTO.class, size, noDuplicates);
            this.addColumn("dateLiv", "Date", FieldType.DATE, null, new ColumnNotNull<DateModeleContratDTO>(e -> e.dateLiv));
        } else {
            this.addDateField("Date de la premi\u00e8re livraison", "dateDebut", new IValidator[0]);
            this.addDateField("Date de la derni\u00e8re livraison", "dateFin", new IValidator[0]);
        }
    }

    private String checkDateLivraison() {
        String check = this.performCheckDateLivraison();
        if (check != null) {
            return check;
        }
        new GestionContratDateUtils().computeDateLivraison(this.modeleContrat);
        return null;
    }

    private String performCheckDateLivraison() {
        if (this.modeleContrat.frequence == FrequenceLivraison.UNE_SEULE_LIVRAISON) {
            return null;
        }
        if (this.modeleContrat.frequence == FrequenceLivraison.AUTRE) {
            return null;
        }
        if (this.modeleContrat.dateDebut.after(this.modeleContrat.dateFin)) {
            return "La date de d\u00e9but doit \u00eatre avant la date de fin ";
        }
        return null;
    }

    @Override
    protected void performSauvegarder() throws OnSaveException {
        new GestionContratService().updateDateModeleContrat(this.modeleContrat);
    }

    @Override
    protected String checkInitialCondition() {
        int nbInscrits = new GestionContratService().getNbInscrits(this.modeleContrat.id);
        if (nbInscrits != 0) {
            String str = "Vous ne pouvez plus modifier les dates de livraison de ce contrat<br/>car " + nbInscrits + " adh\u00e9rents ont d\u00e9j\u00e0 souscrits \u00e0 ce contrat.<br/>" + "Trois cas sont possibles :<br/><ul>" + "<li>Vous souhaitez d\u00e9placer une date. Dans ce cas, vous allez dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\", puis sur \"D\u00e9placer une date de livraison\".</li>" + "<li>Vous souhaitez ajouter une date. Dans ce cas, vous allez dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\", puis sur \"Ajouter une date de livraison\".</li>" + "<li>Une date a \u00e9t\u00e9 r\u00e9ellement annul\u00e9e suite \u00e0 un probl\u00e8me avec le producteur par exemple. Dans ce cas, vous allez dans \"Gestion des contrats sign\u00e9s\", puis vous cliquez sur le bouton \"Modifier en masse\", puis sur \"Mettre \u00e0 z\u00e9ro les quantit\u00e9s command\u00e9es sur une ou plusieurs dates de livraison\"." + "Un assistant vous aidera \u00e0 g\u00e9rer le cas o\u00f9 une ou plusieurs livraisons sont annul\u00e9es.</li>" + "</ul>";
            return str;
        }
        return null;
    }
}

