/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.editorpart.reglesaisie;

import com.rits.cloning.Cloner;
import com.vaadin.data.Property;
import com.vaadin.data.util.BeanItem;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Field;
import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.IdContainer;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RSChampApplication;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RSContrainteDate;
import fr.amapj.model.models.contrat.modele.extendparam.reglesaisie.RSContrainteProduit;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.reglesaisie.RegleSaisieModeleContratService;
import fr.amapj.view.engine.collectioneditor.CollectionEditor;
import fr.amapj.view.engine.collectioneditor.FieldType;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;
import fr.amapj.view.engine.popup.formpopup.fieldlink.FieldLink;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionNoDuplicates;
import fr.amapj.view.engine.popup.formpopup.validator.CollectionSizeValidator;
import fr.amapj.view.engine.popup.formpopup.validator.ColumnNotNull;
import fr.amapj.view.engine.popup.formpopup.validator.IValidator;
import fr.amapj.view.engine.popup.formpopup.validator.NotNullValidator;
import fr.amapj.view.views.searcher.SDModeleContratDate;
import fr.amapj.view.views.searcher.SDProduitOneProducteur;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RegleSaisieOneRegleEditorPart
extends WizardFormPopup {
    private RegleSaisieDTO regleSaisieDTO;
    private RegleSaisieDTO regleSaisieInitial;
    private RegleSaisieModeleContratDTO dto;
    private List<Field<?>> dateComponents = new ArrayList();
    private ComboBox dateBox;
    private List<Field<?>> prodComponents = new ArrayList();
    private ComboBox prodBox;

    public RegleSaisieOneRegleEditorPart(RegleSaisieModeleContratDTO dto, RegleSaisieDTO regleSaisieInitial) {
        this.dto = dto;
        this.regleSaisieInitial = regleSaisieInitial;
        if (regleSaisieInitial == null) {
            this.regleSaisieDTO = new RegleSaisieDTO();
            this.regleSaisieDTO.activateLibPersonnalise = ChoixOuiNon.NON;
            this.regleSaisieDTO.champApplication = RSChampApplication.AMAPIEN;
            this.popupTitle = "Ajout d'une r\u00e8gle de saisie";
        } else {
            this.regleSaisieDTO = (RegleSaisieDTO)new Cloner().deepClone((Object)regleSaisieInitial);
            this.popupTitle = "Modification d'une r\u00e8gle de saisie";
        }
        this.setWidth(50);
        this.setModel(this.regleSaisieDTO);
    }

    @Override
    protected void configure() {
        this.add(() -> this.addFieldDate());
        this.add(() -> this.addFieldProd());
        this.add(() -> this.addFieldOperateur());
        this.add(() -> this.addFieldLibelle(), () -> this.checkLibelle());
        this.add(() -> this.addFieldApplication());
    }

    private void addFieldDate() {
        this.setStepTitle("Les dates");
        this.dateBox = this.addComboEnumField("Filtre date", "contrainteDate", new NotNullValidator());
        this.dateBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.refreshFieldDate());
        this.dateComponents.clear();
        this.refreshFieldDate();
    }

    private void refreshFieldDate() {
        this.dateComponents.forEach(e -> this.suppressElement((Field<?>)e));
        this.dateComponents.clear();
        RSContrainteDate st = (RSContrainteDate)((Object)this.dateBox.getValue());
        if (st == null) {
            return;
        }
        switch (st) {
            case POUR_CHAQUE_DATE: 
            case POUR_TOUT_CONTRAT: {
                break;
            }
            case POUR_UNE_DATE: {
                this.dateComponents.add((Field<?>)this.addSearcher("Date", "modeleContratDateId", new SDModeleContratDate(this.dto.idModeleContrat), null, new NotNullValidator()));
                break;
            }
            case POUR_PLUSIEURS_DATES: {
                CollectionSizeValidator size = new CollectionSizeValidator(1, null);
                CollectionNoDuplicates<IdContainer> noDuplicates = new CollectionNoDuplicates<IdContainer>(e -> e.id);
                CollectionEditor<IdContainer> f1 = new CollectionEditor<IdContainer>("Dates", (BeanItem)this.getModelAsItem(), "modeleContratDateIds", IdContainer.class);
                f1.addSearcherColumn("id", "Date", FieldType.SEARCHER, null, new SDModeleContratDate(this.dto.idModeleContrat), null);
                this.addCollectionEditorFieldToForm(f1, "Dates", "modeleContratDateIds", size, noDuplicates);
                this.addValidatorColumnSearcher("id", "Date", new ColumnNotNull<IdContainer>(e -> e.id));
                this.dateComponents.add((Field<?>)f1);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    private void addFieldProd() {
        this.setStepTitle("Les produits");
        this.prodBox = this.addComboEnumField("Filtre produit", "contrainteProduit", new NotNullValidator());
        this.prodBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.refreshFieldProd());
        this.prodComponents.clear();
        this.refreshFieldProd();
    }

    private void refreshFieldProd() {
        this.prodComponents.forEach(e -> this.suppressElement((Field<?>)e));
        this.prodComponents.clear();
        RSContrainteProduit st = (RSContrainteProduit)((Object)this.prodBox.getValue());
        if (st == null) {
            return;
        }
        switch (st) {
            case POUR_TOUS_PRODUITS: {
                break;
            }
            case POUR_UN_PRODUIT: {
                this.prodComponents.add((Field<?>)this.addSearcher("Produit", "produitId", new SDProduitOneProducteur(this.dto.idProducteur), null, new NotNullValidator()));
                break;
            }
            case POUR_PLUSIEURS_PRODUITS: {
                CollectionSizeValidator size = new CollectionSizeValidator(1, null);
                CollectionNoDuplicates<IdContainer> noDuplicates = new CollectionNoDuplicates<IdContainer>(e -> e.id);
                CollectionEditor<IdContainer> f1 = new CollectionEditor<IdContainer>("Produits", (BeanItem)this.getModelAsItem(), "produitIds", IdContainer.class);
                f1.addSearcherColumn("id", "Produit", FieldType.SEARCHER, null, new SDProduitOneProducteur(this.dto.idProducteur), null);
                this.addCollectionEditorFieldToForm(f1, "Produits", "produitIds", size, noDuplicates);
                this.addValidatorColumnSearcher("id", "Produit", new ColumnNotNull<IdContainer>(e -> e.id));
                this.prodComponents.add((Field<?>)f1);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    private void addFieldOperateur() {
        this.setStepTitle("Operateur");
        this.addComboEnumField("Operateur", "contrainteOperateur", new NotNullValidator());
        this.addIntegerField("Valeur", "val", new IValidator[0]);
    }

    private void addFieldLibelle() {
        this.setStepTitle("Libell\u00e9 personnalis\u00e9");
        this.regleSaisieDTO.libelle = new RegleSaisieModeleContratService().getLib(this.regleSaisieDTO);
        this.addHtml("<b>Libell\u00e9 de la r\u00e8gle</b>");
        this.addHtml(this.regleSaisieDTO.libelle);
        ComboBox b1 = this.addComboEnumField("Saisir un libell\u00e9 personnalis\u00e9", "activateLibPersonnalise", new NotNullValidator());
        FieldLink f1 = new FieldLink(this.validatorManager, Arrays.asList(new Enum[]{ChoixOuiNon.OUI}), b1, true);
        f1.addField(this.addCKEditorFieldForLabel("", "libPersonnalise"));
        f1.doLink();
    }

    private String checkLibelle() {
        if (this.regleSaisieDTO.activateLibPersonnalise == ChoixOuiNon.NON) {
            return null;
        }
        String s = this.regleSaisieDTO.libPersonnalise;
        if (s == null || s.length() == 0 || this.isEmptyHtml(s)) {
            return "Vous devez saisir un libell\u00e9 personnalis\u00e9 ou choisir Saisir un libell\u00e9 personnalis\u00e9=NON";
        }
        return null;
    }

    private boolean isEmptyHtml(String s) {
        s = s.replaceAll("<br />", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll("\n", "");
        return (s = s.replaceAll("&nbsp;", "")).length() == 0;
    }

    private void addFieldApplication() {
        this.setStepTitle("Champ d'application");
        this.addComboEnumField("Champ d'application", "champApplication", new NotNullValidator());
    }

    @Override
    protected void performSauvegarder() {
        if (this.regleSaisieInitial == null) {
            this.dto.regleSaisies.add(this.regleSaisieDTO);
        } else {
            Cloner cloner = new Cloner();
            cloner.copyPropertiesOfInheritedClass((Object)this.regleSaisieDTO, (Object)this.regleSaisieInitial);
        }
    }
}

