/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.listpart;

import fr.amapj.model.engine.IdentifiableUtil;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.listpart.ButtonType;
import fr.amapj.view.engine.listpart.StandardListPart;
import fr.amapj.view.engine.popup.suppressionpopup.SuppressionPopup;
import fr.amapj.view.engine.popup.swicthpopup.SwitchPopup;
import fr.amapj.view.views.common.contrattelecharger.TelechargerContrat;
import fr.amapj.view.views.gestioncontrat.editorpart.ChoixModifEditorPart;
import fr.amapj.view.views.gestioncontrat.editorpart.GestionContratEditorPart;
import fr.amapj.view.views.gestioncontrat.editorpart.ModeleContratVisualiserPart;
import fr.amapj.view.views.gestioncontrat.listpart.PopupContratArchiver;
import fr.amapj.view.views.gestioncontrat.listpart.PopupSaisieEtat;
import fr.amapj.view.views.gestioncontrat.listpart.SaisieEnMassePeriodeCotisation;
import fr.amapj.view.views.saisiecontrat.SaisieContrat;
import fr.amapj.view.views.stock.GestionContratStockPart;
import java.util.List;

public class GestionContratListPart
extends StandardListPart<ModeleContratSummaryDTO> {
    private List<Producteur> allowedProducteurs = new AccessManagementService().getAccessLivraisonProducteur(SessionManager.getUserRoles(), SessionManager.getUserId(), true);

    public GestionContratListPart() {
        super(ModeleContratSummaryDTO.class, false);
    }

    @Override
    protected String getTitle() {
        return "Liste des contrats vierges";
    }

    @Override
    protected void drawButton() {
        this.addButton("Cr\u00e9er", ButtonType.ALWAYS, e -> new GestionContratEditorPart(null, this.allowedProducteurs));
        this.addButton("Cr\u00e9er \u00e0 partir de ...", ButtonType.EDIT_MODE, e -> new GestionContratEditorPart(e.id, this.allowedProducteurs));
        this.addButton("Voir", ButtonType.EDIT_MODE, e -> new ModeleContratVisualiserPart(e.id));
        this.addButton("Modifier", ButtonType.EDIT_MODE, e -> ChoixModifEditorPart.createPopup(e.id));
        this.addButtonAction("Tester", ButtonType.EDIT_MODE, () -> this.handleTester());
        if (new ParametresService().getParametres().etatGestionStock == EtatModule.ACTIF) {
            this.addButton("Stock", ButtonType.EDIT_MODE, e -> GestionContratStockPart.handleStock(e.id));
        }
        this.addButton("T\u00e9l\u00e9charger ...", ButtonType.EDIT_MODE, e -> TelechargerContrat.displayPopupTelechargerContrat(e.id, null));
        this.addButton("Changer l'\u00e9tat", ButtonType.EDIT_MODE, e -> new PopupSaisieEtat((ModeleContratSummaryDTO)e));
        this.addButton("Archiver", ButtonType.EDIT_MODE, e -> new PopupContratArchiver((ModeleContratSummaryDTO)e));
        this.addButton("Autre", ButtonType.ALWAYS, e -> this.handleAutre());
        this.addSearchField("Rechercher par nom ou producteur");
    }

    @Override
    protected void drawTable() {
        this.addColumn("etat", "Etat");
        this.addColumn("nom", "Nom");
        this.addColumn("nomProducteur", "Producteur");
        this.addColumnDate("finInscription", "Fin inscription");
        this.addColumnDate("dateDebut", "Premi\u00e8re livraison");
        this.addColumnDate("dateFin", "Derni\u00e8re livraison");
        this.addColumn("nbLivraison", "Livraisons").center();
        this.addColumn("nbInscrits", "Contrats sign\u00e9s").center();
    }

    @Override
    protected List<ModeleContratSummaryDTO> getLines() {
        return new GestionContratService().getModeleContratInfo(EtatModeleContrat.CREATION, EtatModeleContrat.ACTIF);
    }

    @Override
    protected String[] getSortInfos() {
        return new String[]{"etat", "nomProducteur", "dateDebut"};
    }

    @Override
    protected String[] getSearchInfos() {
        return new String[]{"nom", "nomProducteur"};
    }

    private void handleTester() {
        ModeleContratSummaryDTO mcDto = (ModeleContratSummaryDTO)this.getSelectedLine();
        SaisieContrat.saisieContrat(mcDto.id, null, null, "Mode Test", SaisieContrat.ModeSaisie.FOR_TEST, this);
    }

    private SwitchPopup handleAutre() {
        List<RoleList> roles;
        ModeleContratSummaryDTO dto = (ModeleContratSummaryDTO)this.getSelectedLine();
        SwitchPopup popup = new SwitchPopup("Autres actions possibles sur les modeles de contrats", 60);
        popup.setLine1("Veuillez indiquer ce que vous souhaitez faire :");
        if (this.isEditAllowed()) {
            popup.addLine("Supprimer ce mod\u00e9le de contrat", () -> this.handleSupprimer(dto));
        }
        if ((roles = SessionManager.getUserRoles()).contains((Object)RoleList.ADMIN) || roles.contains((Object)RoleList.TRESORIER)) {
            popup.addLine("Saisir en masse les p\u00e9riodes de cotisations pour tous les mod\u00e9les de contrats", () -> new SaisieEnMassePeriodeCotisation());
        }
        return popup;
    }

    private SuppressionPopup handleSupprimer(ModeleContratSummaryDTO mcDTO) {
        String text = "Etes vous s\u00fbr de vouloir supprimer le contrat vierge " + mcDTO.nom + " de " + mcDTO.nomProducteur + " ?";
        SuppressionPopup confirmPopup = new SuppressionPopup(text, mcDTO.id, e -> new GestionContratService().deleteContrat((Long)e));
        return confirmPopup;
    }

    @Override
    protected boolean isEditAllowed() {
        ModeleContratSummaryDTO mcDto = (ModeleContratSummaryDTO)this.getSelectedLine();
        if (mcDto == null) {
            return false;
        }
        return IdentifiableUtil.contains(this.allowedProducteurs, mcDto.producteurId);
    }
}

