/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.view.views.gestioncontrat.listpart;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.view.engine.popup.formpopup.WizardFormPopup;

public class PopupSaisieEtat
extends WizardFormPopup {
    private ModeleContratSummaryDTO mcDto;
    private EtatModeleContrat selectedValue;

    @Override
    protected void configure() {
        this.add(() -> this.addSaisie());
        this.add(() -> this.addConfirmation());
    }

    public PopupSaisieEtat(ModeleContratSummaryDTO mcDto) {
        this.popupTitle = "Changement de l'\u00e9tat d'un contrat";
        this.mcDto = mcDto;
    }

    protected void addSaisie() {
        String intro = this.computeIntro();
        this.addHtml(intro);
    }

    private String computeIntro() {
        String str = "Votre contrat est actuellement dans l'\u00e9tat " + (Object)((Object)this.mcDto.etat) + ".<br/>";
        switch (this.mcDto.etat) {
            case CREATION: {
                str = String.valueOf(str) + "Pour le moment, votre contrat n'est pas visible par les amapiens. Si vous le passez \u00e0 l'\u00e9tat ACTIF, alors les amapiens pourront s'inscrire \u00e0 ce contrat.";
                break;
            }
            case ACTIF: {
                str = String.valueOf(str) + "Il est donc visible par tous les amapiens. Si vous le passez \u00e0 l'\u00e9tat CREATION, alors il ne sera plus visible par les amapiens.<br/> ATTENTION : ceci bloquera aussi l'envoi automatique des feuilles de distribution au producteur.";
                break;
            }
            default: {
                throw new AmapjRuntimeException("etat=" + (Object)((Object)this.mcDto.etat));
            }
        }
        str = String.valueOf(str) + "<br/><br/>";
        return str;
    }

    private void addConfirmation() {
        this.selectedValue = this.computeNewEtat();
        String str = "Vous allez passer votre contrat du statut " + (Object)((Object)this.mcDto.etat) + " au statut " + (Object)((Object)this.selectedValue) + ".<br/><br/>Cliquez sur Sauvegardez pour confirmer cette modification, ou Annuler pour ne rien faire.";
        this.addHtml(str);
    }

    private EtatModeleContrat computeNewEtat() {
        switch (this.mcDto.etat) {
            case CREATION: {
                return EtatModeleContrat.ACTIF;
            }
            case ACTIF: {
                return EtatModeleContrat.CREATION;
            }
        }
        throw new AmapjRuntimeException("etat=" + (Object)((Object)this.mcDto.etat));
    }

    @Override
    protected void performSauvegarder() {
        new GestionContratService().updateEtat(this.selectedValue, this.mcDto.id);
    }
}

